/*
 * Decompiled with CFR 0.152.
 */
package nl.devpieter.utilize.utils;

public class RandomUtils {
    public static boolean randomChance(double chanceForTrue) {
        if (chanceForTrue <= 0.0) {
            return false;
        }
        if (chanceForTrue >= 100.0) {
            return true;
        }
        return Math.random() * 100.0 < chanceForTrue;
    }

    public static int randomIntInclusive(int min, int max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        return (int)(Math.random() * (double)(max - min + 1)) + min;
    }

    public static double randomDoubleInclusive(double min, double max, double precision) {
        if (precision <= 0.0) {
            throw new IllegalArgumentException("Precision must be positive.");
        }
        if (min == max) {
            return min;
        }
        if (min > max) {
            double temp = min;
            min = max;
            max = temp;
        }
        double range = max - min;
        double randomValue = Math.random() * range + min;
        double rounded = (double)Math.round(randomValue / precision) * precision;
        return Math.min(rounded, max);
    }

    public static float randomFloatInclusive(float min, float max, float precision) {
        if (precision <= 0.0f) {
            throw new IllegalArgumentException("Precision must be positive.");
        }
        if (min == max) {
            return min;
        }
        if (min > max) {
            float temp = min;
            min = max;
            max = temp;
        }
        float range = max - min;
        float randomValue = (float)Math.random() * range + min;
        float rounded = (float)Math.round(randomValue / precision) * precision;
        return Math.min(rounded, max);
    }
}

