/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.world.chunk;

import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import mod.bluestaggo.modernerbeta.api.world.BlockSourceCreator;
import mod.bluestaggo.modernerbeta.api.world.blocksource.BlockSource;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceBuilder;
import mod.bluestaggo.modernerbeta.api.world.spawn.SpawnLocator;
import mod.bluestaggo.modernerbeta.mixin.AccessorChunkGenerator;
import mod.bluestaggo.modernerbeta.mixin.AccessorPlacedFeature;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaGenerationStep;
import mod.bluestaggo.modernerbeta.world.feature.placement.Infdev325CavePlacementModifier;
import mod.bluestaggo.modernerbeta.world.feature.placement.NoiseBasedCountPlacementModifier;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3233;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.class_5817;
import net.minecraft.class_6350;
import net.minecraft.class_6544;
import net.minecraft.class_6568;
import net.minecraft.class_6574;
import net.minecraft.class_6748;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6880;
import net.minecraft.class_6916;
import net.minecraft.class_7138;
import net.minecraft.class_7510;

public abstract class ChunkProvider {
    private final class_6350.class_6565 defaultFluidLevelSampler;
    protected final ModernBetaChunkGenerator chunkGenerator;
    protected final long seed;
    protected final class_6880<class_5284> generatorSettings;
    protected final ModernBetaSettings chunkSettings;
    protected final boolean skipCarvers;
    protected final Random random;
    protected final class_2919.class_6675 randomProvider;
    protected final class_6574 randomSplitter;
    protected final List<BlockSource> blockSources;
    protected final SurfaceBuilder surfaceBuilder;

    public ChunkProvider(ModernBetaChunkGenerator chunkGenerator, long seed) {
        this.chunkGenerator = chunkGenerator;
        this.seed = seed;
        this.generatorSettings = chunkGenerator.getGeneratorSettings();
        this.chunkSettings = ModernBetaSettings.fromCompound(chunkGenerator.getChunkSettings()).mapPreset(chunkGenerator.getPresetRegistry(), ModernBetaSettingsPreset::chunkSettings);
        this.random = new Random(this.seed);
        this.defaultFluidLevelSampler = (x, y, z) -> new class_6350.class_6351(this.getSeaLevel(), BlockStates.AIR);
        this.randomProvider = ((class_5284)chunkGenerator.getGeneratorSettings().comp_349()).method_38999();
        this.randomSplitter = this.randomProvider.method_39006(this.seed).method_38421();
        this.blockSources = ModernBetaRegistries.BLOCKSOURCE.method_42017().map(func -> ((BlockSourceCreator)func.comp_349()).apply(this.chunkSettings, this.randomSplitter)).toList();
        this.surfaceBuilder = new SurfaceBuilder(this.chunkGenerator.method_12098());
        this.skipCarvers = !this.chunkSettings.getOrDefault(SettingsComponentTypes.CAVE_GENERATION).useCarvers();
    }

    public abstract CompletableFuture<class_2791> provideChunk(class_6748 var1, class_5138 var2, class_2791 var3, class_7138 var4);

    public abstract void provideSurface(class_3233 var1, class_5138 var2, class_2791 var3, ModernBetaBiomeSource var4, class_7138 var5);

    public void provideSurfaceExtra(class_3233 region, class_5138 structureAccessor, class_2791 chunk, ModernBetaBiomeSource biomeSource, class_7138 noiseConfig) {
    }

    public abstract int getHeight(int var1, int var2, class_2902.class_2903 var3);

    public boolean skipChunk(int chunkX, int chunkZ, ModernBetaGenerationStep step) {
        if (step == ModernBetaGenerationStep.CARVERS) {
            return this.skipCarvers;
        }
        return false;
    }

    public int getWorldHeight() {
        return ((class_5284)this.generatorSettings.comp_349()).comp_474().comp_174();
    }

    public int getWorldMinY() {
        return ((class_5284)this.generatorSettings.comp_349()).comp_474().comp_173();
    }

    public int getSeaLevel() {
        return ((class_5284)this.generatorSettings.comp_349()).comp_479();
    }

    public class_6350 getAquiferSampler(class_2791 chunk, class_7138 noiseConfig) {
        return class_6350.method_36381((class_6350.class_6565)this.defaultFluidLevelSampler);
    }

    public class_6350.class_6565 getFluidLevelSampler() {
        return this.defaultFluidLevelSampler;
    }

    public ModernBetaChunkGenerator getChunkGenerator() {
        return this.chunkGenerator;
    }

    public SpawnLocator getSpawnLocator() {
        return SpawnLocator.DEFAULT;
    }

    public void initForestOctaveNoise() {
        List<class_7510.class_6827> generationSteps = ((AccessorChunkGenerator)((Object)this.chunkGenerator)).getIndexedFeaturesListSupplier().get();
        for (class_7510.class_6827 step : generationSteps) {
            List featureList = step.comp_303();
            for (class_6796 placedFeature : featureList) {
                AccessorPlacedFeature accessor = (AccessorPlacedFeature)placedFeature;
                List<class_6797> modifiers = accessor.getPlacementModifiers();
                for (class_6797 modifier : modifiers) {
                    if (modifier instanceof NoiseBasedCountPlacementModifier) {
                        NoiseBasedCountPlacementModifier noiseModifier = (NoiseBasedCountPlacementModifier)modifier;
                        noiseModifier.setOctaves(this.getForestOctaveNoise());
                        continue;
                    }
                    if (!(modifier instanceof Infdev325CavePlacementModifier)) continue;
                    Infdev325CavePlacementModifier noiseModifier = (Infdev325CavePlacementModifier)modifier;
                    noiseModifier.setOctaves(this.getForestOctaveNoise());
                }
            }
        }
    }

    public class_6880<class_1959> getBiome(int biomeX, int biomeY, int biomeZ, class_6544.class_6552 noiseSampler) {
        return this.chunkGenerator.method_12098().method_38109(biomeX, biomeY, biomeZ, noiseSampler);
    }

    public class_6568 createChunkNoiseSampler(class_2791 chunk, class_5138 world, class_6748 blender, class_7138 noiseConfig) {
        return class_6568.method_39543((class_2791)chunk, (class_7138)noiseConfig, (class_6916.class_7050)class_5817.method_42695((class_5138)world, (class_1923)chunk.method_12004()), (class_5284)((class_5284)this.generatorSettings.comp_349()), (class_6350.class_6565)this.getFluidLevelSampler(), (class_6748)blender);
    }

    public ModernBetaSettings getChunkSettings() {
        return this.chunkSettings;
    }

    protected Random createSurfaceRandom(int chunkX, int chunkZ) {
        long seed = (long)chunkX * 341873128712L + (long)chunkZ * 132897987541L;
        return new Random(seed);
    }

    protected PerlinOctaveNoise getForestOctaveNoise() {
        return new PerlinOctaveNoise(new Random(this.seed), 8, true);
    }
}

