/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util.chunk;

import java.util.Arrays;
import net.minecraft.class_2902;

public class ChunkHeightmap {
    private final short[] heightmapSurface;
    private final short[] heightmapOcean;
    private final short[] heightmapSurfaceFloor;

    public ChunkHeightmap(short[] heightmapSurface, short[] heightmapOcean, short[] heightmapSurfaceFloor) {
        if (heightmapSurface.length != 256 || heightmapOcean.length != 256) {
            throw new IllegalArgumentException("[Modern Beta] Heightmap is an invalid size!");
        }
        this.heightmapSurface = heightmapSurface;
        this.heightmapOcean = heightmapOcean;
        this.heightmapSurfaceFloor = heightmapSurfaceFloor;
    }

    public ChunkHeightmap(int minHeight) {
        this.heightmapSurface = new short[256];
        this.heightmapOcean = new short[256];
        this.heightmapSurfaceFloor = new short[256];
        Arrays.fill(this.heightmapSurface, (short)minHeight);
        Arrays.fill(this.heightmapOcean, (short)minHeight);
        Arrays.fill(this.heightmapSurfaceFloor, (short)0);
    }

    public int getHeight(int x, int z, class_2902.class_2903 type) {
        int ndx = (z & 0xF) + (x & 0xF) * 16;
        return switch (type) {
            case class_2902.class_2903.field_13197 -> this.heightmapOcean[ndx];
            case class_2902.class_2903.field_13203 -> this.heightmapOcean[ndx];
            case class_2902.class_2903.field_13200 -> this.heightmapSurface[ndx];
            case class_2902.class_2903.field_13195 -> this.heightmapSurface[ndx];
            case class_2902.class_2903.field_13202 -> this.heightmapOcean[ndx];
            case class_2902.class_2903.field_13194 -> this.heightmapOcean[ndx];
            default -> this.heightmapSurface[ndx];
        };
    }

    public int getHeight(int x, int z, Type type) {
        int ndx = (z & 0xF) + (x & 0xF) * 16;
        return switch (type.ordinal()) {
            case 1 -> this.heightmapSurface[ndx];
            case 2 -> this.heightmapOcean[ndx];
            case 0 -> this.heightmapSurfaceFloor[ndx];
            default -> this.heightmapSurface[ndx];
        };
    }

    public static enum Type {
        SURFACE_FLOOR,
        SURFACE,
        OCEAN;

    }
}

