/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util.noise;

import java.util.Random;
import net.minecraft.class_3532;

public class PerlinNoise {
    private int[] permutations = new int[512];
    public double offsetX = 0.0;
    public double offsetY = 0.0;
    public double offsetZ = 0.0;

    public PerlinNoise() {
        this(new Random(), false);
    }

    public PerlinNoise(Random random, boolean useOffset) {
        int i;
        if (useOffset) {
            this.offsetX = random.nextDouble() * 256.0;
            this.offsetY = random.nextDouble() * 256.0;
            this.offsetZ = random.nextDouble() * 256.0;
        }
        for (i = 0; i < 256; ++i) {
            this.permutations[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            int j = random.nextInt(256 - i) + i;
            int k = this.permutations[i];
            this.permutations[i] = this.permutations[j];
            this.permutations[j] = k;
            this.permutations[i + 256] = this.permutations[i];
        }
    }

    public double sample(double x, double y) {
        return this.sample(x, y, 0.0);
    }

    public double sample(double x, double y, double z) {
        int floorX = class_3532.method_15357((double)(x += this.offsetX));
        int floorY = class_3532.method_15357((double)(y += this.offsetY));
        int floorZ = class_3532.method_15357((double)(z += this.offsetZ));
        int X = floorX & 0xFF;
        int Y = floorY & 0xFF;
        int Z = floorZ & 0xFF;
        double u = PerlinNoise.fade(x -= (double)floorX);
        double v = PerlinNoise.fade(y -= (double)floorY);
        double w = PerlinNoise.fade(z -= (double)floorZ);
        int A = this.permutations[X] + Y;
        int AA = this.permutations[A] + Z;
        int AB = this.permutations[A + 1] + Z;
        int B = this.permutations[X + 1] + Y;
        int BA = this.permutations[B] + Z;
        int BB = this.permutations[B + 1] + Z;
        return PerlinNoise.lerp(w, PerlinNoise.lerp(v, PerlinNoise.lerp(u, PerlinNoise.grad(this.permutations[AA], x, y, z), PerlinNoise.grad(this.permutations[BA], x - 1.0, y, z)), PerlinNoise.lerp(u, PerlinNoise.grad(this.permutations[AB], x, y - 1.0, z), PerlinNoise.grad(this.permutations[BB], x - 1.0, y - 1.0, z))), PerlinNoise.lerp(v, PerlinNoise.lerp(u, PerlinNoise.grad(this.permutations[AA + 1], x, y, z - 1.0), PerlinNoise.grad(this.permutations[BA + 1], x - 1.0, y, z - 1.0)), PerlinNoise.lerp(u, PerlinNoise.grad(this.permutations[AB + 1], x, y - 1.0, z - 1.0), PerlinNoise.grad(this.permutations[BB + 1], x - 1.0, y - 1.0, z - 1.0))));
    }

    public void sampleAlpha(double[] arr, double x, double y, double z, int sizeX, int sizeY, int sizeZ, double scaleX, double scaleY, double scaleZ, double frequency) {
        int ndx = 0;
        frequency = 1.0 / frequency;
        int flagY = -1;
        double lerp0 = 0.0;
        double lerp1 = 0.0;
        double lerp2 = 0.0;
        double lerp3 = 0.0;
        for (int sX = 0; sX < sizeX; ++sX) {
            for (int sZ = 0; sZ < sizeZ; ++sZ) {
                for (int sY = 0; sY < sizeY; ++sY) {
                    double curX = (x + (double)sX) * scaleX + this.offsetX;
                    double curY = (y + (double)sY) * scaleY + this.offsetY;
                    double curZ = (z + (double)sZ) * scaleZ + this.offsetZ;
                    int floorX = class_3532.method_15357((double)curX);
                    int floorY = class_3532.method_15357((double)curY);
                    int floorZ = class_3532.method_15357((double)curZ);
                    int X = floorX & 0xFF;
                    int Y = floorY & 0xFF;
                    int Z = floorZ & 0xFF;
                    double u = PerlinNoise.fade(curX -= (double)floorX);
                    double v = PerlinNoise.fade(curY -= (double)floorY);
                    double w = PerlinNoise.fade(curZ -= (double)floorZ);
                    if (sY == 0 || Y != flagY) {
                        flagY = Y;
                        int A = this.permutations[X] + Y;
                        int AA = this.permutations[A] + Z;
                        int AB = this.permutations[A + 1] + Z;
                        int B = this.permutations[X + 1] + Y;
                        int BA = this.permutations[B] + Z;
                        int BB = this.permutations[B + 1] + Z;
                        lerp0 = PerlinNoise.lerp(u, PerlinNoise.grad(this.permutations[AA], curX, curY, curZ), PerlinNoise.grad(this.permutations[BA], curX - 1.0, curY, curZ));
                        lerp1 = PerlinNoise.lerp(u, PerlinNoise.grad(this.permutations[AB], curX, curY - 1.0, curZ), PerlinNoise.grad(this.permutations[BB], curX - 1.0, curY - 1.0, curZ));
                        lerp2 = PerlinNoise.lerp(u, PerlinNoise.grad(this.permutations[AA + 1], curX, curY, curZ - 1.0), PerlinNoise.grad(this.permutations[BA + 1], curX - 1.0, curY, curZ - 1.0));
                        lerp3 = PerlinNoise.lerp(u, PerlinNoise.grad(this.permutations[AB + 1], curX, curY - 1.0, curZ - 1.0), PerlinNoise.grad(this.permutations[BB + 1], curX - 1.0, curY - 1.0, curZ - 1.0));
                    }
                    double res = PerlinNoise.lerp(w, PerlinNoise.lerp(v, lerp0, lerp1), PerlinNoise.lerp(v, lerp2, lerp3));
                    int n = ndx++;
                    arr[n] = arr[n] + res * frequency;
                }
            }
        }
    }

    public void sampleBeta(double[] arr, double x, double y, double z, int sizeX, int sizeY, int sizeZ, double scaleX, double scaleY, double scaleZ, double frequency) {
        if (sizeY != 1) {
            this.sampleAlpha(arr, x, y, z, sizeX, sizeY, sizeZ, scaleX, scaleY, scaleZ, frequency);
        } else {
            int ndx = 0;
            for (int sX = 0; sX < sizeX; ++sX) {
                for (int sZ = 0; sZ < sizeZ; ++sZ) {
                    double curX = (x + (double)sX) * scaleX;
                    double curZ = (z + (double)sZ) * scaleZ;
                    int n = ndx++;
                    arr[n] = arr[n] + this.sampleXZ(curX, curZ, frequency);
                }
            }
        }
    }

    public double sampleXZ(double x, double z, double frequency) {
        frequency = 1.0 / frequency;
        int floorX = class_3532.method_15357((double)(x += this.offsetX));
        int floorZ = class_3532.method_15357((double)(z += this.offsetZ));
        int X = floorX & 0xFF;
        int Z = floorZ & 0xFF;
        double u = PerlinNoise.fade(x -= (double)floorX);
        double w = PerlinNoise.fade(z -= (double)floorZ);
        int A = this.permutations[X] + 0;
        int AA = this.permutations[A] + Z;
        int B = this.permutations[X + 1] + 0;
        int BA = this.permutations[B] + Z;
        double lerp0 = PerlinNoise.lerp(u, PerlinNoise.grad(this.permutations[AA], x, 0.0, z), PerlinNoise.grad(this.permutations[BA], x - 1.0, 0.0, z));
        double lerp1 = PerlinNoise.lerp(u, PerlinNoise.grad(this.permutations[AA + 1], x, 0.0, z - 1.0), PerlinNoise.grad(this.permutations[BA + 1], x - 1.0, 0.0, z - 1.0));
        double res = PerlinNoise.lerp(w, lerp0, lerp1);
        return res * frequency;
    }

    public double sampleXYZ(double x, double y, double z, double yScale, double yMax) {
        int floorX = class_3532.method_15357((double)(x += this.offsetX));
        int floorY = class_3532.method_15357((double)(y += this.offsetY));
        int floorZ = class_3532.method_15357((double)(z += this.offsetZ));
        x -= (double)floorX;
        y -= (double)floorY;
        z -= (double)floorZ;
        double yOffset = 0.0;
        if (yScale != 0.0) {
            yOffset = yMax >= 0.0 && yMax < y ? yMax : y;
            yOffset = (double)class_3532.method_15357((double)(yOffset / yScale + (double)1.0E-7f)) * yScale;
        } else {
            yOffset = 0.0;
        }
        return this.sampleXYZ(floorX, floorY, floorZ, x, y - yOffset, z, y);
    }

    private double sampleXYZ(int floorX, int floorY, int floorZ, double localX, double localOffsetY, double localZ, double localY) {
        int X = floorX & 0xFF;
        int Y = floorY & 0xFF;
        int Z = floorZ & 0xFF;
        int A = this.permutations[X] + Y;
        int AA = this.permutations[A] + Z;
        int AB = this.permutations[A + 1] + Z;
        int B = this.permutations[X + 1] + Y;
        int BA = this.permutations[B] + Z;
        int BB = this.permutations[B + 1] + Z;
        double grad0 = PerlinNoise.grad(this.permutations[AA], localX, localOffsetY, localZ);
        double grad1 = PerlinNoise.grad(this.permutations[BA], localX - 1.0, localOffsetY, localZ);
        double grad2 = PerlinNoise.grad(this.permutations[AB], localX, localOffsetY - 1.0, localZ);
        double grad3 = PerlinNoise.grad(this.permutations[BB], localX - 1.0, localOffsetY - 1.0, localZ);
        double grad4 = PerlinNoise.grad(this.permutations[AA + 1], localX, localOffsetY, localZ - 1.0);
        double grad5 = PerlinNoise.grad(this.permutations[BA + 1], localX - 1.0, localOffsetY, localZ - 1.0);
        double grad6 = PerlinNoise.grad(this.permutations[AB + 1], localX, localOffsetY - 1.0, localZ - 1.0);
        double grad7 = PerlinNoise.grad(this.permutations[BB + 1], localX - 1.0, localOffsetY - 1.0, localZ - 1.0);
        double u = PerlinNoise.fade(localX);
        double v = PerlinNoise.fade(localY);
        double w = PerlinNoise.fade(localZ);
        return class_3532.method_16438((double)u, (double)v, (double)w, (double)grad0, (double)grad1, (double)grad2, (double)grad3, (double)grad4, (double)grad5, (double)grad6, (double)grad7);
    }

    private static double lerp(double delta, double start, double end) {
        return start + delta * (end - start);
    }

    private static double grad(int hash, double x, double y, double z) {
        switch (hash & 0xF) {
            case 0: {
                return x + y;
            }
            case 1: {
                return -x + y;
            }
            case 2: {
                return x - y;
            }
            case 3: {
                return -x - y;
            }
            case 4: {
                return x + z;
            }
            case 5: {
                return -x + z;
            }
            case 6: {
                return x - z;
            }
            case 7: {
                return -x - z;
            }
            case 8: {
                return y + z;
            }
            case 9: {
                return -y + z;
            }
            case 10: {
                return y - z;
            }
            case 11: {
                return -y - z;
            }
            case 12: {
                return y + x;
            }
            case 13: {
                return -y + z;
            }
            case 14: {
                return y - x;
            }
            case 15: {
                return -y - z;
            }
        }
        return 0.0;
    }

    private static double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }
}

