/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverBlock;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverExtendedId;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverOcean;
import mod.bluestaggo.modernerbeta.api.world.cavebiome.CaveBiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.provider.BiomeProviderType;
import mod.bluestaggo.modernerbeta.api.world.provider.CaveBiomeProviderType;
import mod.bluestaggo.modernerbeta.registry.IRegistryHandler;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistryKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.biome.injector.BiomeInjector;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class ModernBetaBiomeSource
extends class_1966 {
    public static final MapCodec<ModernBetaBiomeSource> CODEC = VersionCompat.createMaybeMapCodec(instance -> instance.group((App)class_6903.method_46636((class_5321)class_7924.field_41236), (App)class_6903.method_46636(ModernBetaRegistryKeys.SETTINGS_PRESET), (App)class_2487.field_25128.fieldOf("provider_settings").forGetter(biomeSource -> biomeSource.biomeSettings), (App)class_2487.field_25128.fieldOf("cave_provider_settings").forGetter(biomeSource -> biomeSource.caveBiomeSettings)).apply((Applicative)instance, instance.stable(ModernBetaBiomeSource::new)));
    private final class_7871<class_1959> biomeRegistry;
    private final class_7871<ModernBetaSettingsPreset> presetRegistry;
    private final class_2487 biomeSettings;
    private final class_2487 caveBiomeSettings;
    private BiomeProvider biomeProvider;
    private CaveBiomeProvider caveBiomeProvider;
    private ModernBetaChunkGenerator chunkGenerator;

    public ModernBetaBiomeSource(class_7871<class_1959> biomeRegistry, class_7871<ModernBetaSettingsPreset> presetRegistry, class_2487 biomeSettings, class_2487 caveBiomeSettings) {
        this.biomeRegistry = biomeRegistry;
        this.presetRegistry = presetRegistry;
        this.biomeSettings = biomeSettings;
        this.caveBiomeSettings = caveBiomeSettings;
    }

    public void initProvider(long seed) {
        ModernBetaSettings biomeSettings = ModernBetaSettings.fromCompound(this.biomeSettings).mapPreset(this.presetRegistry, ModernBetaSettingsPreset::biomeSettings);
        ModernBetaSettings caveBiomeSettings = ModernBetaSettings.fromCompound(this.caveBiomeSettings).mapPreset(this.presetRegistry, ModernBetaSettingsPreset::caveBiomeSettings);
        this.biomeProvider = ((BiomeProviderType)ModernBetaRegistries.BIOME.method_63535(biomeSettings.getProvider())).apply(biomeSettings, this.biomeRegistry, seed);
        this.caveBiomeProvider = ((CaveBiomeProviderType)ModernBetaRegistries.CAVE_BIOME.method_63535(caveBiomeSettings.getProvider())).apply(caveBiomeSettings, this.biomeRegistry, seed);
    }

    public class_6880<class_1959> method_38109(int biomeX, int biomeY, int biomeZ, class_6544.class_6552 noiseSampler) {
        return this.biomeProvider.getBiome(biomeX, biomeY, biomeZ);
    }

    public Set<class_6880<class_1959>> method_8763(int startX, int startY, int startZ, int radius, class_6544.class_6552 noiseSampler) {
        if (this.chunkGenerator == null) {
            return super.method_8763(startX, startY, startZ, radius, noiseSampler);
        }
        int minX = class_5742.method_33100((int)(startX - radius));
        int minZ = class_5742.method_33100((int)(startZ - radius));
        int maxX = class_5742.method_33100((int)(startX + radius));
        int maxZ = class_5742.method_33100((int)(startZ + radius));
        int rangeX = maxX - minX + 1;
        int rangeZ = maxZ - minZ + 1;
        HashSet set = Sets.newHashSet();
        for (int localZ = 0; localZ < rangeZ; ++localZ) {
            for (int localX = 0; localX < rangeX; ++localX) {
                int biomeX = minX + localX;
                int biomeZ = minZ + localZ;
                int x = biomeX << 2;
                int z = biomeZ << 2;
                int y = this.chunkGenerator.getHeight(x, z, class_2902.class_2903.field_13195);
                set.add(this.chunkGenerator.getBiomeInjector().getBiomeAtBlock(x, y, z, noiseSampler, BiomeInjector.BiomeInjectionStep.ALL));
            }
        }
        return set;
    }

    public Pair<class_2338, class_6880<class_1959>> method_42310(class_2338 origin, int radius, int horizontalBlockCheckInterval, int verticalBlockCheckInterval, Predicate<class_6880<class_1959>> predicate, class_6544.class_6552 noiseSampler, class_4538 world) {
        if (this.chunkGenerator != null) {
            // empty if block
        }
        return super.method_42310(origin, radius, horizontalBlockCheckInterval, verticalBlockCheckInterval, predicate, noiseSampler, world);
    }

    public class_6880<class_1959> getOceanBiome(int biomeX, int biomeY, int biomeZ) {
        BiomeProvider biomeProvider = this.biomeProvider;
        if (biomeProvider instanceof BiomeResolverOcean) {
            BiomeResolverOcean biomeResolverOcean = (BiomeResolverOcean)((Object)biomeProvider);
            return biomeResolverOcean.getOceanBiome(biomeX, biomeY, biomeZ);
        }
        return this.biomeProvider.getBiome(biomeX, biomeY, biomeZ);
    }

    public class_6880<class_1959> getDeepOceanBiome(int biomeX, int biomeY, int biomeZ) {
        BiomeProvider biomeProvider = this.biomeProvider;
        if (biomeProvider instanceof BiomeResolverOcean) {
            BiomeResolverOcean biomeResolverOcean = (BiomeResolverOcean)((Object)biomeProvider);
            return biomeResolverOcean.getDeepOceanBiome(biomeX, biomeY, biomeZ);
        }
        return this.biomeProvider.getBiome(biomeX, biomeY, biomeZ);
    }

    public class_6880<class_1959> getCaveBiome(int biomeX, int biomeY, int biomeZ) {
        return this.caveBiomeProvider.getBiome(biomeX, biomeY, biomeZ);
    }

    public class_6880<class_1959> getBiomeForSpawn(int x, int y, int z) {
        BiomeProvider biomeProvider = this.biomeProvider;
        if (biomeProvider instanceof BiomeResolverBlock) {
            BiomeResolverBlock biomeResolver = (BiomeResolverBlock)((Object)biomeProvider);
            return biomeResolver.getBiomeBlock(x, y, z);
        }
        return this.biomeProvider.getBiome(x >> 2, y >> 2, z >> 2);
    }

    public class_6880<class_1959> getBiomeForSurfaceGen(class_3233 region, class_2338 pos) {
        BiomeProvider biomeProvider = this.biomeProvider;
        if (biomeProvider instanceof BiomeResolverBlock) {
            BiomeResolverBlock biomeResolver = (BiomeResolverBlock)((Object)biomeProvider);
            return biomeResolver.getBiomeBlock(pos.method_10263(), pos.method_10264(), pos.method_10260());
        }
        return region.method_23753(pos);
    }

    public ExtendedBiomeId getBiomeForHeightGen(int biomeX, int biomeY, int biomeZ) {
        BiomeProvider biomeProvider = this.biomeProvider;
        if (biomeProvider instanceof BiomeResolverExtendedId) {
            BiomeResolverExtendedId biomeResolver = (BiomeResolverExtendedId)((Object)biomeProvider);
            return biomeResolver.getExtendedBiomeId(biomeX, biomeY, biomeZ);
        }
        return ExtendedBiomeId.of(((class_5321)this.biomeProvider.getBiome(biomeX, biomeY, biomeZ).method_40230().orElseThrow()).method_29177());
    }

    public void setChunkGenerator(ModernBetaChunkGenerator chunkGenerator) {
        this.chunkGenerator = chunkGenerator;
    }

    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    public CaveBiomeProvider getCaveBiomeProvider() {
        return this.caveBiomeProvider;
    }

    public class_2487 getBiomeSettings() {
        return this.biomeSettings;
    }

    public class_2487 getCaveBiomeSettings() {
        return this.caveBiomeSettings;
    }

    public boolean hasOceanBiomes() {
        return this.biomeProvider instanceof BiomeResolverOcean;
    }

    public static void register(IRegistryHandler<?> handler) {
        IRegistryHandler<?> registryHandler = handler;
        registryHandler.register(ModernerBeta.createId("moderner_beta"), CODEC);
    }

    protected MapCodec<? extends class_1966> method_28442() {
        return CODEC;
    }

    protected Stream<class_6880<class_1959>> method_49494() {
        ModernBetaSettings biomeSettings = ModernBetaSettings.fromCompound(this.biomeSettings).mapPreset(this.presetRegistry, ModernBetaSettingsPreset::biomeSettings);
        ModernBetaSettings caveBiomeSettings = ModernBetaSettings.fromCompound(this.caveBiomeSettings).mapPreset(this.presetRegistry, ModernBetaSettingsPreset::caveBiomeSettings);
        Object biomeProvider = ((BiomeProviderType)ModernBetaRegistries.BIOME.method_63535(biomeSettings.getProvider())).apply(biomeSettings, this.biomeRegistry, 0L);
        Object caveBiomeProvider = ((CaveBiomeProviderType)ModernBetaRegistries.CAVE_BIOME.method_63535(caveBiomeSettings.getProvider())).apply(caveBiomeSettings, this.biomeRegistry, 0L);
        ArrayList<class_6880<class_1959>> biomes = new ArrayList<class_6880<class_1959>>();
        biomes.addAll(((BiomeProvider)biomeProvider).getBiomes());
        biomes.addAll(((CaveBiomeProvider)caveBiomeProvider).getBiomes());
        return biomes.stream();
    }
}

