/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleImmutableList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerType;
import net.minecraft.class_3537;
import net.minecraft.class_5819;
import net.minecraft.class_6575;

public class MappedNoiseLayer
extends Layer {
    public static final MapCodec<MappedNoiseLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> MappedNoiseLayer.fillLayerFields(instance).and(instance.group((App)Entry.CODEC.listOf().fieldOf("values").forGetter(layer -> Stream.concat(layer.lowerBiomes.stream(), Stream.concat(Stream.of(new Entry(0.0, layer.middleBiome)), layer.upperBiomes.stream())).toList()), (App)Codec.DOUBLE.fieldOf("scale").orElse((Object)1.0).forGetter(layer -> layer.scale), (App)Codec.DOUBLE.listOf().fieldOf("amplitudes").orElse(List.of(Double.valueOf(1.0))).forGetter(layer -> layer.amplitudes), (App)Codec.BOOL.fieldOf("useSaltedSeed").orElse((Object)true).forGetter(layer -> layer.useSaltedSeed))).apply((Applicative)instance, MappedNoiseLayer::new));
    private final List<Entry> lowerBiomes;
    private final List<Entry> upperBiomes;
    private final ExtendedBiomeId middleBiome;
    private final double scale;
    private final DoubleList amplitudes;
    private final boolean useSaltedSeed;
    private transient class_3537 noiseSampler;

    public MappedNoiseLayer(String id, long seed, List<Entry> values, double scale, List<Double> amplitudes, boolean useSaltedSeed) {
        this(id, seed, values, scale, (DoubleList)new DoubleImmutableList(amplitudes), useSaltedSeed);
    }

    public MappedNoiseLayer(String id, long seed, List<Entry> values, double scale, DoubleList amplitudes, boolean useSaltedSeed) {
        super(id, seed);
        this.middleBiome = values.stream().filter((Predicate<Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$5(mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.MappedNoiseLayer$Entry ), (Lmod/bluestaggo/modernerbeta/world/biome/provider/fractal/layers/MappedNoiseLayer$Entry;)Z)()).findFirst().orElseThrow((Supplier<RuntimeException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$6(), ()Ljava/lang/RuntimeException;)()).biome;
        this.lowerBiomes = values.stream().filter(pair -> pair.value < 0.0).sorted(Comparator.comparingDouble(Entry::value)).toList();
        this.upperBiomes = values.stream().filter(pair -> pair.value > 0.0).sorted(Comparator.comparingDouble(Entry::value).reversed()).toList();
        this.scale = scale;
        this.amplitudes = amplitudes;
        this.useSaltedSeed = useSaltedSeed;
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.MAPPED_NOISE;
    }

    @Override
    public void init(long worldSeed) {
        super.init(worldSeed);
        long noiseSeed = this.useSaltedSeed ? this.getSaltedSeed() : worldSeed;
        this.noiseSampler = class_3537.method_39126((class_5819)new class_6575(noiseSeed), (int)0, (DoubleList)this.amplitudes);
    }

    @Override
    public void initUnsalted() {
        super.initUnsalted();
        this.noiseSampler = class_3537.method_39126((class_5819)new class_6575(0L), (int)0, (DoubleList)this.amplitudes);
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        double noiseValue = this.noiseSampler.method_15416((double)x / this.scale, (double)z / this.scale, 0.0);
        for (Entry lowerBiome : this.lowerBiomes) {
            if (!(noiseValue < lowerBiome.value)) continue;
            return lowerBiome.biome;
        }
        for (Entry upperBiome : this.upperBiomes) {
            if (!(noiseValue > upperBiome.value)) continue;
            return upperBiome.biome;
        }
        return this.middleBiome;
    }

    @Override
    protected void addPossibleBiomes(Set<ExtendedBiomeId> biomes) {
        this.lowerBiomes.forEach(pair -> biomes.add(pair.biome));
        this.upperBiomes.forEach(pair -> biomes.add(pair.biome));
        biomes.add(this.middleBiome);
    }

    private static /* synthetic */ RuntimeException lambda$new$6() {
        return new RuntimeException("No biome at noise value 0.0 provided!");
    }

    private static /* synthetic */ boolean lambda$new$5(Entry pair) {
        return pair.value == 0.0;
    }

    public record Entry(double value, ExtendedBiomeId biome) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("value").forGetter(Entry::value), (App)ExtendedBiomeId.CODEC.fieldOf("biome").forGetter(Entry::biome)).apply((Applicative)instance, Entry::new));
    }
}

