/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.chunk.provider;

import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderNoiseImitable;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.Infdev227Structures;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkCache;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.util.noise.SimpleNoisePos;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.blocksource.BlockSourceRules;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5817;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;

public class ChunkProviderInfdev227
extends ChunkProvider
implements ChunkProviderNoiseImitable {
    private final int worldMinY;
    private final int worldHeight;
    private final int worldTopY;
    private final int seaLevel;
    private final int bedrockFloor;
    private final class_2680 defaultBlock;
    private final class_2680 defaultFluid;
    private final boolean infdevUsePyramid;
    private final boolean infdevUseWall;
    private final PerlinOctaveNoise octaveNoiseA;
    private final PerlinOctaveNoise octaveNoiseB;
    private final PerlinOctaveNoise octaveNoiseC;
    private final PerlinOctaveNoise octaveNoiseD;
    private final PerlinOctaveNoise octaveNoiseE;
    private final PerlinOctaveNoise octaveNoiseF;
    private final PerlinOctaveNoise forestOctaveNoise;
    private final ChunkCache<int[]> chunkCacheHeightmap;

    public ChunkProviderInfdev227(ModernBetaChunkGenerator chunkGenerator, long seed) {
        super(chunkGenerator, seed);
        class_5284 generatorSettings = (class_5284)this.chunkGenerator.getGeneratorSettings().comp_349();
        class_5309 shapeConfig = generatorSettings.comp_474();
        this.worldMinY = shapeConfig.comp_173();
        this.worldHeight = shapeConfig.comp_174();
        this.worldTopY = this.worldHeight + this.worldMinY;
        this.seaLevel = generatorSettings.comp_479();
        this.bedrockFloor = 0;
        this.defaultBlock = generatorSettings.comp_475();
        this.defaultFluid = generatorSettings.comp_476();
        Infdev227Structures structures = this.chunkSettings.getOrDefault(SettingsComponentTypes.INFDEV_227_STRUCTURES);
        this.infdevUsePyramid = structures.brickPyramids();
        this.infdevUseWall = structures.obsidianWalls();
        this.octaveNoiseA = new PerlinOctaveNoise(this.random, 16, true);
        this.octaveNoiseB = new PerlinOctaveNoise(this.random, 16, true);
        this.octaveNoiseC = new PerlinOctaveNoise(this.random, 8, true);
        this.octaveNoiseD = new PerlinOctaveNoise(this.random, 4, true);
        this.octaveNoiseE = new PerlinOctaveNoise(this.random, 4, true);
        this.octaveNoiseF = new PerlinOctaveNoise(this.random, 5, true);
        this.forestOctaveNoise = new PerlinOctaveNoise(this.random, 5, true);
        this.chunkCacheHeightmap = new ChunkCache<int[]>("heightmap", this::sampleHeightmapChunk);
    }

    @Override
    public CompletableFuture<class_2791> provideChunk(class_6748 blender, class_5138 structureAccessor, class_2791 chunk, class_7138 noiseConfig) {
        this.generateTerrain(chunk, structureAccessor);
        return CompletableFuture.supplyAsync(() -> chunk, (Executor)class_156.method_18349());
    }

    @Override
    public void provideSurface(class_3233 region, class_5138 structureAccessor, class_2791 chunk, ModernBetaBiomeSource biomeSource, class_7138 noiseConfig) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_1923 chunkPos = chunk.method_12004();
        int chunkX = chunkPos.field_9181;
        int chunkZ = chunkPos.field_9180;
        int startX = chunk.method_12004().method_8326();
        int startZ = chunk.method_12004().method_8328();
        int bedrockFloor = this.worldMinY + this.bedrockFloor;
        Random bedrockRand = this.createSurfaceRandom(chunkX, chunkZ);
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int x = startX + localX;
                int z = startZ + localZ;
                int surfaceTopY = chunk.method_12032(class_2902.class_2903.field_13195).method_12603(localX, localZ) - 1;
                class_6880<class_1959> biome = biomeSource.getBiomeForSurfaceGen(region, (class_2338)pos.method_10103(x, surfaceTopY, z));
                SurfaceConfig surfaceConfig = this.surfaceBuilder.getSurfaceConfig(biome);
                class_2680 topBlock = surfaceConfig.normal().topBlock();
                class_2680 fillerBlock = surfaceConfig.normal().fillerBlock();
                int runDepth = 0;
                for (int y = this.worldTopY; y >= this.worldMinY; --y) {
                    boolean inFluid;
                    pos.method_10103(localX, y, localZ);
                    class_2680 blockState = chunk.method_8320((class_2338)pos);
                    if (y <= bedrockFloor + bedrockRand.nextInt(5)) {
                        VersionCompat.setBlockState(chunk, (class_2338)pos, BlockStates.BEDROCK);
                        continue;
                    }
                    boolean bl = inFluid = blockState.equals(BlockStates.AIR) || blockState.equals(this.defaultFluid);
                    if (inFluid) {
                        runDepth = 0;
                        continue;
                    }
                    if (!blockState.method_27852(this.defaultBlock.method_26204())) continue;
                    if (runDepth == 0) {
                        class_2680 class_26802 = blockState = y >= this.seaLevel ? topBlock : fillerBlock;
                    }
                    if (runDepth == 1) {
                        blockState = fillerBlock;
                    }
                    ++runDepth;
                    VersionCompat.setBlockState(chunk, (class_2338)pos, blockState);
                }
            }
        }
    }

    @Override
    public int getHeight(int x, int z, class_2902.class_2903 type) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        int[] heightmap = this.chunkCacheHeightmap.get(chunkX, chunkZ);
        int height = heightmap[(z & 0xF) + (x & 0xF) * 16];
        if (type == class_2902.class_2903.field_13194 && height < this.seaLevel) {
            height = this.seaLevel;
        }
        return height + 1;
    }

    protected void generateTerrain(class_2791 chunk, class_5138 structureAccessor) {
        Random rand = new Random();
        class_2902 heightmapOcean = chunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 heightmapSurface = chunk.method_12032(class_2902.class_2903.field_13194);
        class_5817 structureWeightSampler = class_5817.method_42695((class_5138)structureAccessor, (class_1923)chunk.method_12004());
        class_2338.class_2339 mutable = new class_2338.class_2339();
        SimpleNoisePos noisePos = new SimpleNoisePos();
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int startX = chunk.method_12004().method_8326();
        int startZ = chunk.method_12004().method_8328();
        ChunkProviderNoiseImitable.BlockHolder blockHolder = new ChunkProviderNoiseImitable.BlockHolder();
        class_2248 defaultBlock = this.defaultBlock.method_26204();
        class_2248 defaultFluid = this.defaultFluid.method_26204();
        BlockSourceRules.Builder builder = new BlockSourceRules.Builder().add(this.getBaseBlockSource(structureWeightSampler, noisePos, blockHolder, defaultBlock, defaultFluid));
        this.blockSources.forEach(builder::add);
        builder.add(this.getActualBlockSource(blockHolder));
        BlockSourceRules blockSources = builder.build(this.defaultBlock);
        for (int localX = 0; localX < 16; ++localX) {
            int x = startX + localX;
            int rX = x / 1024;
            for (int localZ = 0; localZ < 16; ++localZ) {
                int z = startZ + localZ;
                int rZ = z / 1024;
                int[] heightmap = this.chunkCacheHeightmap.get(chunkX, chunkZ);
                int height = heightmap[(z & 0xF) + (x & 0xF) * 16];
                for (int y = this.worldMinY; y < this.worldTopY; ++y) {
                    class_2248 block = class_2246.field_10124;
                    if (this.infdevUseWall && (x == 0 || z == 0) && y <= height + 2) {
                        block = class_2246.field_10540;
                    } else if (y <= height) {
                        block = defaultBlock;
                    } else if (y <= this.seaLevel) {
                        block = defaultFluid;
                    }
                    if (this.infdevUsePyramid) {
                        rand.setSeed(rX + rZ * 13871);
                        int bX = (rX << 10) + 128 + rand.nextInt(512);
                        int bZ = (rZ << 10) + 128 + rand.nextInt(512);
                        bX = x - bX;
                        bZ = z - bZ;
                        if (bX < 0) {
                            bX = -bX;
                        }
                        if (bZ < 0) {
                            bZ = -bZ;
                        }
                        if (bZ > bX) {
                            bX = bZ;
                        }
                        if ((bX = 127 - bX) == 255) {
                            bX = 1;
                        }
                        if (bX < height) {
                            bX = height;
                        }
                        if (y <= bX && (block == class_2246.field_10124 || block == defaultFluid)) {
                            block = class_2246.field_10104;
                        }
                    }
                    blockHolder.setBlock(block);
                    class_2680 blockState = blockSources.apply(x, y, z);
                    VersionCompat.setBlockState(chunk, (class_2338)mutable.method_10103(localX, y, localZ), blockState);
                    heightmapOcean.method_12597(localX, y, localZ, blockState);
                    heightmapSurface.method_12597(localX, y, localZ, blockState);
                }
            }
        }
    }

    @Override
    protected PerlinOctaveNoise getForestOctaveNoise() {
        return this.forestOctaveNoise;
    }

    private int sampleHeightmap(int x, int z) {
        float noiseA = (float)(this.octaveNoiseA.sample((float)x / 0.03125f, 0.0, (float)z / 0.03125f) - this.octaveNoiseB.sample((float)x / 0.015625f, 0.0, (float)z / 0.015625f)) / 512.0f / 4.0f;
        float noiseB = (float)this.octaveNoiseE.sampleXY((float)x / 4.0f, (float)z / 4.0f);
        float noiseC = (float)this.octaveNoiseF.sampleXY((float)x / 8.0f, (float)z / 8.0f) / 8.0f;
        noiseB = noiseB > 0.0f ? (float)(this.octaveNoiseC.sampleXY((float)x * 0.25714284f * 2.0f, (float)z * 0.25714284f * 2.0f) * (double)noiseC / 4.0) : (float)(this.octaveNoiseD.sampleXY((float)x * 0.25714284f, (float)z * 0.25714284f) * (double)noiseC);
        int heightVal = (int)(noiseA + (float)this.seaLevel + noiseB);
        if ((float)this.octaveNoiseE.sampleXY(x, z) < 0.0f) {
            heightVal = heightVal / 2 << 1;
            if ((float)this.octaveNoiseE.sampleXY(x / 5, z / 5) < 0.0f) {
                ++heightVal;
            }
        }
        return heightVal;
    }

    private int[] sampleHeightmapChunk(int chunkX, int chunkZ) {
        int[] heightmap = new int[256];
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        int ndx = 0;
        for (int x = startX; x < startX + 16; ++x) {
            for (int z = startZ; z < startZ + 16; ++z) {
                heightmap[ndx++] = this.sampleHeightmap(x, z);
            }
        }
        return heightmap;
    }
}

