/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.world.chunk;

import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;

public class AquiferSamplerProvider {
    private static final int FAR_LANDS_BOUNDARY = 12550821;
    private final NoiseRouter noiseRouter;
    private final PositionalRandomFactory randomSplitter;
    private final Aquifer.FluidPicker fluidLevelSampler;
    private final Aquifer.FluidPicker lavalessFluidLevelSampler;
    private final NoiseChunk chunkSampler;
    private final int worldMinY;
    private final int worldHeight;
    private final int noiseResolutionVertical;
    private final boolean generateAquifers;

    public AquiferSamplerProvider(NoiseRouter noiseRouter, BlockState defaultFluid, int seaLevel, int lavaLevel) {
        this(noiseRouter, new SingleThreadedRandomSource(-1L).forkPositional(), null, defaultFluid, seaLevel, lavaLevel, 0, 0, 0, false);
    }

    public AquiferSamplerProvider(NoiseRouter noiseRouter, PositionalRandomFactory randomSplitter, NoiseChunk chunkSampler, BlockState defaultFluid, int seaLevel, int lavaLevel, int worldMinY, int worldHeight, int noiseResolutionVertical, boolean generateAquifers) {
        this.noiseRouter = noiseRouter;
        this.randomSplitter = randomSplitter.fromHashOf(ModernerBeta.createId("aquifer")).forkPositional();
        Aquifer.FluidStatus lavaFluidLevel = new Aquifer.FluidStatus(lavaLevel, BlockStates.LAVA);
        Aquifer.FluidStatus seaFluidLevel = new Aquifer.FluidStatus(seaLevel, defaultFluid);
        this.fluidLevelSampler = (x, y, z) -> {
            if (Math.abs(x) >= 12550821 || Math.abs(z) >= 12550821) {
                return seaFluidLevel;
            }
            return y < lavaLevel ? lavaFluidLevel : seaFluidLevel;
        };
        this.lavalessFluidLevelSampler = (x, y, z) -> seaFluidLevel;
        this.chunkSampler = chunkSampler;
        this.worldMinY = worldMinY;
        this.worldHeight = worldHeight;
        this.noiseResolutionVertical = noiseResolutionVertical;
        this.generateAquifers = generateAquifers;
    }

    public Aquifer provideAquiferSampler(ChunkAccess chunk) {
        if (!this.generateAquifers) {
            return Aquifer.createDisabled((Aquifer.FluidPicker)this.lavalessFluidLevelSampler);
        }
        int minY = Math.max(this.worldMinY, chunk.getMinY());
        int topY = Math.min(this.worldMinY + this.worldHeight, VersionCompat.getTopYExclusive((LevelHeightAccessor)chunk));
        int noiseMinY = Mth.floorDiv((int)minY, (int)this.noiseResolutionVertical);
        int noiseTopY = Mth.floorDiv((int)(topY - minY), (int)this.noiseResolutionVertical);
        return Aquifer.create((NoiseChunk)this.chunkSampler, (ChunkPos)chunk.getPos(), (NoiseRouter)this.noiseRouter, (PositionalRandomFactory)this.randomSplitter, (int)(noiseMinY * this.noiseResolutionVertical), (int)(noiseTopY * this.noiseResolutionVertical), (Aquifer.FluidPicker)this.fluidLevelSampler);
    }
}

