/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.world.chunk;

import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import mod.bluestaggo.modernerbeta.api.world.BlockSourceCreator;
import mod.bluestaggo.modernerbeta.api.world.blocksource.BlockSource;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceBuilder;
import mod.bluestaggo.modernerbeta.api.world.spawn.SpawnLocator;
import mod.bluestaggo.modernerbeta.mixin.AccessorChunkGenerator;
import mod.bluestaggo.modernerbeta.mixin.AccessorPlacedFeature;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaGenerationStep;
import mod.bluestaggo.modernerbeta.world.feature.placement.Infdev325CavePlacementModifier;
import mod.bluestaggo.modernerbeta.world.feature.placement.NoiseBasedCountPlacementModifier;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public abstract class ChunkProvider {
    private final Aquifer.FluidPicker defaultFluidLevelSampler;
    protected final ModernBetaChunkGenerator chunkGenerator;
    protected final long seed;
    protected final Holder<NoiseGeneratorSettings> generatorSettings;
    protected final ModernBetaSettings chunkSettings;
    protected final boolean skipCarvers;
    protected final Random random;
    protected final WorldgenRandom.Algorithm randomProvider;
    protected final PositionalRandomFactory randomSplitter;
    protected final List<BlockSource> blockSources;
    protected final SurfaceBuilder surfaceBuilder;

    public ChunkProvider(ModernBetaChunkGenerator chunkGenerator, long seed) {
        this.chunkGenerator = chunkGenerator;
        this.seed = seed;
        this.generatorSettings = chunkGenerator.getGeneratorSettings();
        this.chunkSettings = ModernBetaSettings.fromCompound(chunkGenerator.getChunkSettings()).mapPreset(chunkGenerator.getPresetRegistry(), ModernBetaSettingsPreset::chunkSettings);
        this.random = new Random(this.seed);
        this.defaultFluidLevelSampler = (x, y, z) -> new Aquifer.FluidStatus(this.getSeaLevel(), BlockStates.AIR);
        this.randomProvider = ((NoiseGeneratorSettings)chunkGenerator.getGeneratorSettings().value()).getRandomSource();
        this.randomSplitter = this.randomProvider.newInstance(this.seed).forkPositional();
        this.blockSources = ModernBetaRegistries.BLOCKSOURCE.listElements().map(func -> ((BlockSourceCreator)func.value()).apply(this.chunkSettings, this.randomSplitter)).toList();
        this.surfaceBuilder = new SurfaceBuilder(this.chunkGenerator.getBiomeSource());
        this.skipCarvers = !this.chunkSettings.getOrDefault(SettingsComponentTypes.CAVE_GENERATION).useCarvers();
    }

    public abstract CompletableFuture<ChunkAccess> provideChunk(Blender var1, StructureManager var2, ChunkAccess var3, RandomState var4);

    public abstract void provideSurface(WorldGenRegion var1, StructureManager var2, ChunkAccess var3, ModernBetaBiomeSource var4, RandomState var5);

    public void provideSurfaceExtra(WorldGenRegion region, StructureManager structureAccessor, ChunkAccess chunk, ModernBetaBiomeSource biomeSource, RandomState noiseConfig) {
    }

    public abstract int getHeight(LevelHeightAccessor var1, int var2, int var3, Heightmap.Types var4);

    public boolean skipChunk(int chunkX, int chunkZ, ModernBetaGenerationStep step) {
        if (step == ModernBetaGenerationStep.CARVERS) {
            return this.skipCarvers;
        }
        return false;
    }

    public int getWorldHeight() {
        return ((NoiseGeneratorSettings)this.generatorSettings.value()).noiseSettings().height();
    }

    public int getWorldMinY() {
        return ((NoiseGeneratorSettings)this.generatorSettings.value()).noiseSettings().minY();
    }

    public int getSeaLevel() {
        return ((NoiseGeneratorSettings)this.generatorSettings.value()).seaLevel();
    }

    public Aquifer getAquiferSampler(ChunkAccess chunk, RandomState noiseConfig) {
        return Aquifer.createDisabled((Aquifer.FluidPicker)this.defaultFluidLevelSampler);
    }

    public Aquifer.FluidPicker getFluidLevelSampler() {
        return this.defaultFluidLevelSampler;
    }

    public ModernBetaChunkGenerator getChunkGenerator() {
        return this.chunkGenerator;
    }

    public SpawnLocator getSpawnLocator() {
        return SpawnLocator.DEFAULT;
    }

    public void initForestOctaveNoise() {
        List<FeatureSorter.StepFeatureData> generationSteps = ((AccessorChunkGenerator)((Object)this.chunkGenerator)).getIndexedFeaturesListSupplier().get();
        for (FeatureSorter.StepFeatureData step : generationSteps) {
            List featureList = step.features();
            for (PlacedFeature placedFeature : featureList) {
                AccessorPlacedFeature accessor = (AccessorPlacedFeature)placedFeature;
                List<PlacementModifier> modifiers = accessor.getPlacementModifiers();
                for (PlacementModifier modifier : modifiers) {
                    if (modifier instanceof NoiseBasedCountPlacementModifier) {
                        NoiseBasedCountPlacementModifier noiseModifier = (NoiseBasedCountPlacementModifier)modifier;
                        noiseModifier.setOctaves(this.getForestOctaveNoise());
                        continue;
                    }
                    if (!(modifier instanceof Infdev325CavePlacementModifier)) continue;
                    Infdev325CavePlacementModifier noiseModifier = (Infdev325CavePlacementModifier)modifier;
                    noiseModifier.setOctaves(this.getForestOctaveNoise());
                }
            }
        }
    }

    public Holder<Biome> getBiome(int biomeX, int biomeY, int biomeZ, Climate.Sampler noiseSampler) {
        return this.chunkGenerator.getBiomeSource().getNoiseBiome(biomeX, biomeY, biomeZ, noiseSampler);
    }

    public NoiseChunk createChunkNoiseSampler(ChunkAccess chunk, StructureManager world, Blender blender, RandomState noiseConfig) {
        return NoiseChunk.forChunk((ChunkAccess)chunk, (RandomState)noiseConfig, (DensityFunctions.BeardifierOrMarker)Beardifier.forStructuresInChunk((StructureManager)world, (ChunkPos)chunk.getPos()), (NoiseGeneratorSettings)((NoiseGeneratorSettings)this.generatorSettings.value()), (Aquifer.FluidPicker)this.getFluidLevelSampler(), (Blender)blender);
    }

    public ModernBetaSettings getChunkSettings() {
        return this.chunkSettings;
    }

    protected Random createSurfaceRandom(int chunkX, int chunkZ) {
        long seed = (long)chunkX * 341873128712L + (long)chunkZ * 132897987541L;
        return new Random(seed);
    }

    protected PerlinOctaveNoise getForestOctaveNoise() {
        return new PerlinOctaveNoise(new Random(this.seed), 8, true);
    }
}

