/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.world.chunk;

import mod.bluestaggo.modernerbeta.api.world.blocksource.BlockSource;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.noise.SimpleNoisePos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;

public interface ChunkProviderNoiseImitable {
    default public BlockSource getBaseBlockSource(Beardifier weightSampler, SimpleNoisePos noisePos, BlockHolder blockHolder, Block defaultBlock, Block defaultFluid) {
        return (x, y, z) -> {
            Block originalBlock = blockHolder.getBlock();
            boolean isFluid = originalBlock == defaultFluid;
            boolean isAir = originalBlock == Blocks.AIR;
            boolean isSolid = !isFluid && !isAir;
            double density = !isSolid ? -25.0 : 25.0;
            double clampedDensity = Mth.clamp((double)(density / 200.0), (double)-1.0, (double)1.0);
            clampedDensity = clampedDensity / 2.0 - clampedDensity * clampedDensity * clampedDensity / 24.0;
            clampedDensity += weightSampler.compute((DensityFunction.FunctionContext)noisePos.set(x, y, z));
            BlockState blockState = BlockStates.AIR;
            if (clampedDensity > 0.0) {
                blockState = null;
                if (!isSolid) {
                    blockState = defaultBlock.defaultBlockState();
                }
            } else if (clampedDensity <= 0.0) {
                if (isFluid) {
                    blockState = null;
                }
                if (isSolid) {
                    blockState = BlockStates.AIR;
                }
            }
            return blockState;
        };
    }

    default public BlockSource getActualBlockSource(BlockHolder blockHolder) {
        return (x, y, z) -> blockHolder.getBlock().defaultBlockState();
    }

    public static class BlockHolder {
        private Block block = Blocks.AIR;

        public Block getBlock() {
            return this.block;
        }

        public void setBlock(Block block) {
            this.block = block;
        }
    }
}

