/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.world.chunk.surface;

import java.util.LinkedHashMap;
import java.util.Map;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceConfig;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;

public class SurfaceBuilder {
    private final Map<Holder<Biome>, SurfaceConfig> surfaceConfigs = new LinkedHashMap<Holder<Biome>, SurfaceConfig>();

    public SurfaceBuilder(BiomeSource biomeSource) {
        this.initMap(biomeSource);
    }

    public SurfaceConfig getSurfaceConfig(Holder<Biome> biome) {
        return this.surfaceConfigs.computeIfAbsent(biome, k -> SurfaceConfig.getSurfaceConfig(biome));
    }

    private void initMap(BiomeSource biomeSource) {
        biomeSource.possibleBiomes().stream().forEach(biome -> this.surfaceConfigs.put((Holder<Biome>)biome, SurfaceConfig.getSurfaceConfig((Holder<Biome>)biome)));
    }
}

