/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.color;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.Clime;
import mod.bluestaggo.modernerbeta.client.color.BlockColormap;
import mod.bluestaggo.modernerbeta.mixin.AccessorBiome;
import mod.bluestaggo.modernerbeta.mixin.client.AccessorChunkRendererRegion;
import mod.bluestaggo.modernerbeta.settings.component.ClimateDistribution;
import mod.bluestaggo.modernerbeta.tags.ModernBetaBiomeTags;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class BlockColorSampler {
    private static final int CLIME_CACHE_CAPACITY = 128;
    public static final BlockColorSampler INSTANCE = new BlockColorSampler();
    public final BlockColormap colormapGrass;
    public final BlockColormap colormapFoliage;
    public final BlockColormap colormapWater;
    public final BlockColormap colormapUnderwater;
    private ClimateSampler climateSampler = null;
    private final Long2ObjectLinkedOpenHashMap<Clime> climeCache = new Long2ObjectLinkedOpenHashMap(128);
    private final LoadingCache<Class<?>, Optional<Field>> viewLevelFieldCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Optional<Field>>(this){
        private static final Set<String> PRIORITY_LEVEL_FIELD_NAMES = Set.of("level", "world");

        @NotNull
        public Optional<Field> load(@NotNull Class<?> clazz) {
            List<Field> potentialFields = Arrays.stream(clazz.getDeclaredFields()).filter(field -> LevelReader.class.isAssignableFrom(field.getType())).toList();
            if (potentialFields.isEmpty()) {
                return Optional.empty();
            }
            Field field2 = potentialFields.get(0);
            if (potentialFields.size() > 1) {
                field2 = potentialFields.stream().filter(f -> PRIORITY_LEVEL_FIELD_NAMES.contains(f.getName())).findFirst().orElse(field2);
            }
            if (!Modifier.isPublic(field2.getModifiers()) && !field2.trySetAccessible()) {
                return Optional.empty();
            }
            return Optional.of(field2);
        }
    });

    private BlockColorSampler() {
        this.colormapGrass = new BlockColormap();
        this.colormapFoliage = new BlockColormap();
        this.colormapWater = new BlockColormap();
        this.colormapUnderwater = new BlockColormap();
    }

    public ClimateSampler getClimateSampler() {
        return this.climateSampler;
    }

    public void setClimateSampler(ClimateSampler climateSampler) {
        this.climateSampler = climateSampler;
        this.climeCache.clear();
    }

    private Clime sampleClime(BlockPos pos) {
        return this.sampleClime(pos.getX(), pos.getZ());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Clime sampleClime(int x, int z) {
        Long2ObjectLinkedOpenHashMap<Clime> long2ObjectLinkedOpenHashMap = this.climeCache;
        synchronized (long2ObjectLinkedOpenHashMap) {
            long coord = ChunkPos.asLong((int)x, (int)z);
            Clime clime = (Clime)this.climeCache.get(coord);
            if (clime != null) {
                return clime;
            }
            if (this.climeCache.size() == 128) {
                this.climeCache.removeFirst();
            }
            clime = this.climateSampler.sample(x, z);
            this.climeCache.put(coord, (Object)clime);
            return clime;
        }
    }

    public int getGrassColor(BlockState ignoredState, BlockAndTintGetter view, BlockPos pos, int ignoredTintNdx) {
        if (view == null || pos == null) {
            return GrassColor.getDefaultColor();
        }
        if (this.useBiomeColor()) {
            BiomeManager biomeAccess = this.getBiomeAccessFromView(view);
            if (biomeAccess != null) {
                return this.sampleModifiedColorMaybeLerped(biomeAccess, pos, BiomeSpecialEffects::getGrassColorOverride, BiomeSpecialEffects::getGrassColorModifier, GrassColor::get);
            }
            Clime clime = this.sampleClime(pos);
            return GrassColor.get((double)clime.temp(), (double)clime.rain());
        }
        return BiomeColors.getAverageGrassColor((BlockAndTintGetter)view, (BlockPos)pos);
    }

    public int getPetalColor(BlockState state, BlockAndTintGetter view, BlockPos pos, int tintNdx) {
        if (tintNdx == 0) {
            return -1;
        }
        return this.getShortGrassColor(state, view, pos, tintNdx);
    }

    public int getTallGrassColor(BlockState state, BlockAndTintGetter view, BlockPos pos, int tintNdx) {
        return this.getShortGrassColor(state, view, state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos, tintNdx);
    }

    public int getShortGrassColor(BlockState ignoredState, BlockAndTintGetter view, BlockPos pos, int ignoredTintNdx) {
        if (view == null || pos == null) {
            return GrassColor.getDefaultColor();
        }
        if (this.useBiomeColor()) {
            BiomeManager biomeAccess;
            if (this.getClimateDistribution().fuzzyGrass()) {
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                long shift = (long)x * 3129871L + (long)z * 6129781L + (long)y;
                shift = shift * shift * 42317861L + shift * 11L;
                pos = pos.offset((int)(shift >> 14 & 0x1FL), (int)(shift >> 19 & 0x1FL), (int)(shift >> 24 & 0x1FL));
            }
            if ((biomeAccess = this.getBiomeAccessFromView(view)) != null) {
                return this.sampleModifiedColorMaybeLerped(biomeAccess, pos, BiomeSpecialEffects::getGrassColorOverride, BiomeSpecialEffects::getGrassColorModifier, GrassColor::get);
            }
            Clime clime = this.sampleClime(pos);
            return GrassColor.get((double)clime.temp(), (double)clime.rain());
        }
        return BiomeColors.getAverageGrassColor((BlockAndTintGetter)view, (BlockPos)pos);
    }

    public int getFoliageColor(BlockState ignoredState, BlockAndTintGetter view, BlockPos pos, int ignoredTintNdx) {
        if (view == null || pos == null) {
            return -12012264;
        }
        if (this.useBiomeColor()) {
            BiomeManager biomeAccess = this.getBiomeAccessFromView(view);
            if (biomeAccess != null) {
                return this.sampleModifiedColorMaybeLerped(biomeAccess, pos, BiomeSpecialEffects::getFoliageColorOverride, effects -> BiomeSpecialEffects.GrassColorModifier.NONE, FoliageColor::get);
            }
            Clime clime = this.sampleClime(pos);
            return FoliageColor.get((double)clime.temp(), (double)clime.rain());
        }
        return BiomeColors.getAverageFoliageColor((BlockAndTintGetter)view, (BlockPos)pos);
    }

    public int getWaterColor(BlockState ignoredState, BlockAndTintGetter view, BlockPos pos, int ignoredTintNdx) {
        if (view == null || pos == null) {
            return -1;
        }
        if (this.useWaterColor()) {
            Clime clime = this.sampleClime(pos);
            return this.colormapWater.getColor(clime.temp(), clime.rain());
        }
        return BiomeColors.getAverageWaterColor((BlockAndTintGetter)view, (BlockPos)pos);
    }

    public int getSugarCaneColor(BlockState ignoredState, BlockAndTintGetter view, BlockPos pos, int ignoredTintNdx) {
        if (view == null || pos == null) {
            return -1;
        }
        if (this.useBiomeColor()) {
            return -1;
        }
        return BiomeColors.getAverageGrassColor((BlockAndTintGetter)view, (BlockPos)pos);
    }

    public boolean useBiomeColor() {
        return this.climateSampler != null && this.climateSampler.useBiomeColor();
    }

    public boolean useWaterColor() {
        return this.climateSampler != null && this.climateSampler.useWaterColor();
    }

    public ClimateDistribution getClimateDistribution() {
        if (this.climateSampler == null) {
            return ClimateDistribution.DEFAULT;
        }
        return this.climateSampler.getDistribution();
    }

    private int sampleModifiedColorMaybeLerped(BiomeManager biomeAccess, BlockPos pos, Function<BiomeSpecialEffects, Optional<Integer>> customColorAccessor, Function<BiomeSpecialEffects, BiomeSpecialEffects.GrassColorModifier> grassColorModifierAccessor, ClimateToColorOperator baseColorAccessor) {
        if (this.getClimateDistribution().smoothBorders()) {
            return this.sampleModifiedColorLerped(biomeAccess, pos, customColorAccessor, grassColorModifierAccessor, baseColorAccessor);
        }
        return this.sampleModifiedColor(biomeAccess, pos, customColorAccessor, grassColorModifierAccessor, baseColorAccessor);
    }

    private int sampleModifiedColorLerped(BiomeManager biomeAccess, BlockPos pos, Function<BiomeSpecialEffects, Optional<Integer>> customColorAccessor, Function<BiomeSpecialEffects, BiomeSpecialEffects.GrassColorModifier> grassColorModifierAccessor, ClimateToColorOperator baseColorAccessor) {
        int r = 0;
        int g = 0;
        int b = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    int color = this.sampleModifiedColor(biomeAccess, pos.offset(x, y, z), customColorAccessor, grassColorModifierAccessor, baseColorAccessor);
                    r += color >> 16 & 0xFF;
                    g += color >> 8 & 0xFF;
                    b += color & 0xFF;
                }
            }
        }
        return r / 27 << 16 | g / 27 << 8 | b / 27;
    }

    private int sampleModifiedColor(BiomeManager biomeAccess, BlockPos pos, Function<BiomeSpecialEffects, Optional<Integer>> customColorAccessor, Function<BiomeSpecialEffects, BiomeSpecialEffects.GrassColorModifier> grassColorModifierAccessor, ClimateToColorOperator baseColorAccessor) {
        Clime clime = this.sampleClime(pos);
        int climateColor = baseColorAccessor.apply(clime.temp(), clime.rain());
        Holder biomeEntry = biomeAccess.getBiome(pos);
        int finalColor = climateColor;
        if (biomeEntry.is(ModernBetaBiomeTags.HAS_EARLY_RELEASE_SWAMP_COLORS)) {
            finalColor = ((finalColor & 0xFEFEFE) + 0x4E0E4E) / 2;
        } else {
            BiomeSpecialEffects.GrassColorModifier grassColorModifier;
            Biome biome = (Biome)biomeEntry.value();
            Optional<Integer> optionalCustomColor = customColorAccessor.apply(biome.getSpecialEffects());
            if (optionalCustomColor.isPresent()) {
                int customColor = optionalCustomColor.get();
                Biome.ClimateSettings weather = ((AccessorBiome)biome).getWeather();
                float temperature = Mth.clamp((float)weather.temperature(), (float)0.0f, (float)1.0f);
                float downfall = Mth.clamp((float)weather.downfall(), (float)0.0f, (float)1.0f);
                int baseColor = baseColorAccessor.apply(temperature, downfall);
                int modR = (customColor >> 16 & 0xFF) * 255 / (baseColor >> 16 & 0xFF);
                int modG = (customColor >> 8 & 0xFF) * 255 / (baseColor >> 8 & 0xFF);
                int modB = (customColor & 0xFF) * 255 / (baseColor & 0xFF);
                int r = Mth.clamp((int)((climateColor >> 16 & 0xFF) * modR / 255), (int)0, (int)255);
                int g = Mth.clamp((int)((climateColor >> 8 & 0xFF) * modG / 255), (int)0, (int)255);
                int b = Mth.clamp((int)((climateColor & 0xFF) * modB / 255), (int)0, (int)255);
                finalColor = r << 16 | g << 8 | b;
            }
            if ((grassColorModifier = grassColorModifierAccessor.apply(biome.getSpecialEffects())) != BiomeSpecialEffects.GrassColorModifier.NONE) {
                finalColor = grassColorModifier.modifyColor((double)pos.getX(), (double)pos.getZ(), finalColor);
            }
        }
        return finalColor;
    }

    private BiomeManager getBiomeAccessFromView(BlockAndTintGetter view) {
        Optional levelField;
        if (view instanceof Level) {
            Level world = (Level)view;
            return world.getBiomeManager();
        }
        if (view instanceof LevelReader) {
            LevelReader worldView = (LevelReader)view;
            return worldView.getBiomeManager();
        }
        if (view instanceof RenderChunkRegion) {
            return ((AccessorChunkRendererRegion)view).getWorld().getBiomeManager();
        }
        try {
            levelField = (Optional)this.viewLevelFieldCache.get((Object)view.getClass());
        }
        catch (ExecutionException e) {
            this.viewLevelFieldCache.put((Object)view.getClass(), Optional.empty());
            e.printStackTrace();
            return null;
        }
        if (levelField.isPresent()) {
            try {
                return ((LevelReader)((Field)levelField.get()).get(view)).getBiomeManager();
            }
            catch (IllegalAccessException e) {
                this.viewLevelFieldCache.put((Object)view.getClass(), Optional.empty());
                e.printStackTrace();
            }
        }
        return null;
    }

    @FunctionalInterface
    private static interface ClimateToColorOperator {
        public int apply(double var1, double var3);
    }
}

