/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.color;

import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSamplerSky;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkyColorSampler {
    public static final SkyColorSampler INSTANCE = new SkyColorSampler();
    private ClimateSamplerSky climateSampler = null;

    public ClimateSamplerSky getClimateSampler() {
        return this.climateSampler;
    }

    public void setClimateSampler(ClimateSamplerSky climateSampler) {
        this.climateSampler = climateSampler;
    }

    public Vec3 getSkyColor(Vec3 cameraPos, Vec3 skyColorVec) {
        if (this.useSkyColor()) {
            int x = (int)cameraPos.x();
            int z = (int)cameraPos.z();
            float temp = (float)this.climateSampler.sampleSky(x, z);
            temp /= 3.0f;
            temp = Mth.clamp((float)temp, (float)-1.0f, (float)1.0f);
            return Vec3.fromRGB24((int)Mth.hsvToRgb((float)(0.6222222f - temp * 0.05f), (float)(0.5f + temp * 0.1f), (float)1.0f));
        }
        return skyColorVec;
    }

    public boolean useSkyColor() {
        return this.climateSampler != null && this.climateSampler.useSkyColor();
    }
}

