/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.debug.hudentry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mod.bluestaggo.modernerbeta.api.debug.DebugTextProvider2D;
import mod.bluestaggo.modernerbeta.api.debug.DebugTextProvider3D;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClimateDebugHudEntry {
    public static Collection<String> getLines(Level world, int x, int y, int z) {
        if (!(world instanceof ServerLevel)) {
            return List.of();
        }
        ServerLevel serverWorld = (ServerLevel)world;
        ChunkGenerator chunkGenerator = serverWorld.getChunkSource().getGenerator();
        BiomeSource biomeSource = chunkGenerator.getBiomeSource();
        ArrayList<String> lines = new ArrayList<String>();
        if (biomeSource instanceof ModernBetaBiomeSource) {
            ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)biomeSource;
            Object object = modernBetaBiomeSource.getBiomeProvider();
            if (object instanceof DebugTextProvider2D) {
                DebugTextProvider2D provider2D = (DebugTextProvider2D)object;
                lines.add("[Modern Beta] " + provider2D.getDebugText(x, z));
            }
            if ((object = modernBetaBiomeSource.getCaveBiomeProvider()) instanceof DebugTextProvider3D) {
                DebugTextProvider3D provider3D = (DebugTextProvider3D)object;
                lines.add("[Modern Beta] " + provider3D.getDebugText(x, y, z));
            }
        }
        return lines;
    }
}

