/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.debug.hudentry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HeightmapDebugHudEntry {
    public static Collection<String> getLines(Level world, int x, int z) {
        if (!(world instanceof ServerLevel)) {
            return List.of();
        }
        ServerLevel serverWorld = (ServerLevel)world;
        ChunkGenerator chunkGenerator = serverWorld.getChunkSource().getGenerator();
        ArrayList<String> lines = new ArrayList<String>();
        if (chunkGenerator instanceof ModernBetaChunkGenerator) {
            ModernBetaChunkGenerator modernBetaChunkGenerator = (ModernBetaChunkGenerator)chunkGenerator;
            ChunkProvider chunkProvider = modernBetaChunkGenerator.getChunkProvider();
            lines.add(String.format("[Modern Beta] Chunk Provider WS height: %d OF height: %d Sea level: %d", chunkProvider.getHeight((LevelHeightAccessor)world, x, z, Heightmap.Types.WORLD_SURFACE_WG), chunkProvider.getHeight((LevelHeightAccessor)world, x, z, Heightmap.Types.OCEAN_FLOOR), chunkProvider.getSeaLevel()));
            if (chunkProvider instanceof ChunkProviderNoise) {
                ChunkProviderNoise noiseChunkProvider = (ChunkProviderNoise)chunkProvider;
                lines.add(String.format("[Modern Beta] Noise Chunk Provider WSF height: %d", noiseChunkProvider.getHeight((LevelHeightAccessor)world, x, z, ChunkHeightmap.Type.SURFACE_FLOOR)));
            }
        }
        return lines;
    }
}

