/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen;

import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverExtendedId;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverExtendedIdStepped;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverStepped;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.api.world.provider.BiomeProviderType;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaScreen;
import mod.bluestaggo.modernerbeta.mixin.client.AccessorScreenshotRecorder;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerRandom;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.event.Level;

@OnlyIn(value=Dist.CLIENT)
public class ModernBetaBiomePreviewScreen
extends ModernBetaScreen {
    private final BiomeProvider biomeProvider;
    private BiomeDisplayWidget biomeDisplay;
    private volatile String exceptionMessage;

    public ModernBetaBiomePreviewScreen(Component title, Screen parent, WorldCreationContext generationOptions, ModernBetaSettings biomeSettings) {
        super(title, parent);
        Object biomeProvider = null;
        try {
            biomeProvider = ((BiomeProviderType)ModernBetaRegistries.BIOME.getValue(biomeSettings.getProvider())).apply(biomeSettings, (HolderGetter<Biome>)generationOptions.worldgenLoadContext().lookupOrThrow(Registries.BIOME), generationOptions.options().seed());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.exceptionMessage = exception.getLocalizedMessage();
        }
        this.biomeProvider = biomeProvider;
    }

    @Override
    protected void init() {
        super.init();
        if (this.biomeDisplay != null) {
            this.biomeDisplay.close();
        }
        this.biomeDisplay = new BiomeDisplayWidget(0, 0, this.width * 3 / 4, this.height * 3 / 4);
        boolean hasSteps = this.biomeProvider instanceof BiomeResolverStepped;
        Button buttonZoomOut = Button.builder((Component)Component.literal((String)"-"), button -> this.biomeDisplay.zoomOut()).bounds(0, 0, 20, 20).build();
        Button buttonZoomIn = Button.builder((Component)Component.literal((String)"+"), button -> this.biomeDisplay.zoomIn()).bounds(0, 0, 20, 20).build();
        Button buttonScreenshot = Button.builder((Component)Component.translatable((String)"createWorld.customize.modern_beta.settings.screenshot"), button -> this.biomeDisplay.saveScreenshot()).bounds(0, 0, 100, 20).build();
        Button buttonBack = Button.builder((Component)CommonComponents.GUI_BACK, button -> this.minecraft.setScreen(this.parent)).bounds(0, 0, 100, 20).build();
        GridLayout gridWidgetMain = this.createGridWidget();
        GridLayout gridWidgetButtons = this.createGridWidget();
        gridWidgetMain.defaultCellSetting().alignHorizontallyCenter().alignVerticallyMiddle();
        GridLayout.RowHelper gridAdderMain = gridWidgetMain.createRowHelper(1);
        GridLayout.RowHelper gridAdderButtons = gridWidgetButtons.createRowHelper(hasSteps ? 6 : 4);
        gridAdderMain.addChild((LayoutElement)this.biomeDisplay);
        gridAdderMain.addChild((LayoutElement)gridWidgetButtons);
        gridAdderButtons.addChild((LayoutElement)buttonZoomOut);
        gridAdderButtons.addChild((LayoutElement)buttonZoomIn);
        if (hasSteps) {
            BiomeResolverStepped stepResolver = (BiomeResolverStepped)((Object)this.biomeProvider);
            int stepCount = stepResolver.getStepCount();
            this.biomeDisplay.step.set(stepCount - 1);
            Button buttonPrevStep = Button.builder((Component)Component.literal((String)"\u25c0"), button -> {
                this.biomeDisplay.step.getAndUpdate(i -> Math.floorMod(i - 1, stepCount));
                this.biomeDisplay.clear();
            }).bounds(0, 0, 20, 20).build();
            Button buttonNextStep = Button.builder((Component)Component.literal((String)"\u25b6"), button -> {
                this.biomeDisplay.step.getAndUpdate(i -> Math.floorMod(i + 1, stepCount));
                this.biomeDisplay.clear();
            }).bounds(0, 0, 20, 20).build();
            gridAdderButtons.addChild((LayoutElement)buttonPrevStep);
            gridAdderButtons.addChild((LayoutElement)buttonNextStep);
        }
        gridAdderButtons.addChild((LayoutElement)buttonScreenshot);
        gridAdderButtons.addChild((LayoutElement)buttonBack);
        gridWidgetMain.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)gridWidgetMain, (int)0, (int)0, (int)this.width, (int)this.height, (float)0.5f, (float)1.0f);
        gridWidgetMain.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.biomeDisplay.startRenderThread();
    }

    public void removed() {
        this.biomeDisplay.close();
    }

    class BiomeDisplayWidget
    extends AbstractWidget
    implements AutoCloseable {
        static final ResourceLocation TEXTURE_ID = ModernerBeta.createId("biome_preview");
        static final int EMPTY_COLOR = 0x7F000000;
        final TextureManager textureManager;
        final NativeImage image;
        final DynamicTexture texture;
        final BiomeRenderThread renderThread;
        final AtomicInteger zoomOut;
        final AtomicInteger zoomIn;
        final AtomicInteger step;
        int prevMouseX;
        int prevMouseY;
        final AtomicDouble offsetX;
        final AtomicDouble offsetY;

        BiomeDisplayWidget(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.empty());
            this.zoomOut = new AtomicInteger(1);
            this.zoomIn = new AtomicInteger(1);
            this.step = new AtomicInteger();
            this.offsetX = new AtomicDouble();
            this.offsetY = new AtomicDouble();
            assert (ModernBetaBiomePreviewScreen.this.minecraft != null);
            this.image = new NativeImage(width, height, false);
            this.image.fillRect(0, 0, width, height, 0x7F000000);
            this.texture = new DynamicTexture(() -> ((ResourceLocation)TEXTURE_ID).toString(), this.image);
            this.texture.upload();
            this.textureManager = ModernBetaBiomePreviewScreen.this.minecraft.getTextureManager();
            this.textureManager.register(TEXTURE_ID, (AbstractTexture)this.texture);
            this.renderThread = new BiomeRenderThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            Object object = this.image;
            synchronized (object) {
                this.image.fillRect(0, 0, this.width, this.height, 0x7F000000);
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }

        void zoomOut() {
            if (this.zoomIn.get() > 1) {
                this.zoomIn.getAndUpdate(i -> i / 2);
            } else if (this.zoomOut.get() < 0x1000000) {
                this.zoomOut.getAndUpdate(i -> i * 2);
            } else {
                return;
            }
            this.offsetX.getAndUpdate(i -> i / 2.0);
            this.offsetY.getAndUpdate(i -> i / 2.0);
            this.clear();
        }

        void zoomIn() {
            if (this.zoomOut.get() <= 1) {
                if (this.zoomIn.get() >= 0x1000000) {
                    return;
                }
                this.zoomIn.getAndUpdate(i -> i * 2);
            } else {
                this.zoomOut.getAndUpdate(i -> i / 2);
            }
            this.offsetX.getAndUpdate(i -> i * 2.0);
            this.offsetY.getAndUpdate(i -> i * 2.0);
            this.clear();
        }

        void startRenderThread() {
            this.renderThread.start();
        }

        void saveScreenshot() {
            assert (ModernBetaBiomePreviewScreen.this.minecraft != null);
            File screenshotDirectory = new File(((ModernBetaBiomePreviewScreen)ModernBetaBiomePreviewScreen.this).minecraft.gameDirectory, "screenshots");
            screenshotDirectory.mkdir();
            File screenshotPath = AccessorScreenshotRecorder.invokeGetScreenshotFilename(screenshotDirectory);
            Util.ioPool().execute(() -> {
                try {
                    this.image.writeToFile(screenshotPath);
                }
                catch (Exception exception) {
                    ModernerBeta.log(Level.WARN, "Couldn't save screenshot: " + String.valueOf(exception));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float deltaTicks) {
            double zoomLevel;
            int step = this.step.get();
            if (this.renderThread.uploadRequested) {
                NativeImage nativeImage = this.image;
                synchronized (nativeImage) {
                    this.texture.upload();
                }
            }
            context.blit(RenderType::guiTextured, TEXTURE_ID, this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
            BiomeProvider biomeProvider = ModernBetaBiomePreviewScreen.this.biomeProvider;
            if (biomeProvider instanceof BiomeResolverStepped) {
                BiomeResolverStepped resolverStepped = (BiomeResolverStepped)((Object)biomeProvider);
                MutableComponent stepName = Component.literal((String)(step + 1 + "/" + resolverStepped.getStepCount() + " - "));
                stepName.append(resolverStepped.getStepName(step));
                context.fill(this.getX(), this.getY(), this.getX() + ModernBetaBiomePreviewScreen.this.font.width((FormattedText)stepName) + 8, this.getY() + 16, -1442840576);
                context.drawString(ModernBetaBiomePreviewScreen.this.font, (Component)stepName, this.getX() + 4, this.getY() + 4, -1, false);
            }
            MutableComponent zoomLabel = Component.literal((String)("1:" + ((zoomLevel = (double)this.zoomOut.get() * 4.0 / (double)this.zoomIn.get()) % 1.0 == 0.0 ? Integer.toString((int)zoomLevel) : Double.toString(zoomLevel))));
            int zoomLabelWidth = ModernBetaBiomePreviewScreen.this.font.width((FormattedText)zoomLabel);
            context.fill(this.getX() + this.getWidth() - zoomLabelWidth - 8, this.getY(), this.getX() + this.getWidth(), this.getY() + 16, -1442840576);
            context.drawString(ModernBetaBiomePreviewScreen.this.font, (Component)zoomLabel, this.getX() + this.getWidth() - zoomLabelWidth - 4, this.getY() + 4, -1, false);
            if (ModernBetaBiomePreviewScreen.this.exceptionMessage != null) {
                context.drawCenteredString(ModernBetaBiomePreviewScreen.this.font, (Component)Component.literal((String)ModernBetaBiomePreviewScreen.this.exceptionMessage).withStyle(ChatFormatting.RED), this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2 - 4, -1);
            }
            int offsetMouseX = mouseX - this.getX();
            int offsetMouseY = mouseY - this.getY();
            if (ModernBetaBiomePreviewScreen.this.biomeProvider != null && offsetMouseX >= 0 && offsetMouseY >= 0 && offsetMouseX < this.width && offsetMouseY < this.height) {
                Component component;
                int sampleX = (offsetMouseX + (int)Math.round(this.offsetX.get()) - this.width / 2) * this.zoomOut.get() / this.zoomIn.get();
                int sampleY = (offsetMouseY + (int)Math.round(this.offsetY.get()) - this.height / 2) * this.zoomOut.get() / this.zoomIn.get();
                BiomeProvider biomeProvider2 = ModernBetaBiomePreviewScreen.this.biomeProvider;
                if (biomeProvider2 instanceof BiomeResolverStepped) {
                    BiomeResolverStepped resolverStepped = (BiomeResolverStepped)((Object)biomeProvider2);
                    component = resolverStepped.getBiomeNameForStep(sampleX, 64, sampleY, step);
                } else {
                    component = ModernBetaBiomePreviewScreen.this.biomeProvider.getBiomeName(sampleX, 64, sampleY);
                }
                Component biomeName = component;
                context.renderComponentTooltip(ModernBetaBiomePreviewScreen.this.font, List.of(Component.literal((String)(sampleX * 4 + ", " + sampleY * 4)), biomeName), mouseX, mouseY);
            }
            this.prevMouseX = mouseX;
            this.prevMouseY = mouseY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
            assert (ModernBetaBiomePreviewScreen.this.minecraft != null);
            double prevOffsetX = this.offsetX.getAndAdd(-deltaX);
            double prevOffsetY = this.offsetY.getAndAdd(-deltaY);
            int diffOffsetX = (int)Math.round(this.offsetX.get()) - (int)Math.round(prevOffsetX);
            int diffOffsetY = (int)Math.round(this.offsetY.get()) - (int)Math.round(prevOffsetY);
            Object object = this.image;
            synchronized (object) {
                int[] pixels = this.image.getPixels();
                int i = 0;
                this.image.fillRect(0, 0, this.width, this.height, 0x7F000000);
                for (int srcY = 0; srcY < this.height; ++srcY) {
                    for (int srcX = 0; srcX < this.width; ++srcX) {
                        int dstX = srcX - diffOffsetX;
                        int dstY = srcY - diffOffsetY;
                        if (dstX >= 0 && dstX < this.width && dstY >= 0 && dstY < this.height) {
                            this.image.setPixel(dstX, dstY, pixels[i]);
                        }
                        ++i;
                    }
                }
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            if (verticalAmount < 0.0) {
                this.zoomOut();
                return true;
            }
            if (verticalAmount > 0.0) {
                this.zoomIn();
                return true;
            }
            return false;
        }

        protected void updateWidgetNarration(NarrationElementOutput builder) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.renderThread.stop = true;
            this.texture.close();
            this.textureManager.release(TEXTURE_ID);
            BiomeDisplayWidget biomeDisplayWidget = this;
            synchronized (biomeDisplayWidget) {
                this.notify();
            }
        }

        class BiomeRenderThread
        extends Thread {
            static final Pattern EXT_INT = Pattern.compile("(\\d)+$");
            volatile boolean stop;
            volatile boolean uploadRequested;

            BiomeRenderThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (ModernBetaBiomePreviewScreen.this.biomeProvider == null) {
                    return;
                }
                int genX = -1;
                int genY = 0;
                boolean full = true;
                Int2IntAVLTreeMap randColors = new Int2IntAVLTreeMap();
                Random random = new Random();
                LayerRandom voronoiRandom = new LayerRandom(RandomSupport.generateUniqueSeed());
                try {
                    while (!this.stop) {
                        ExtendedBiomeId extendedBiomeId;
                        Holder<Biome> holder;
                        if (++genX >= BiomeDisplayWidget.this.width) {
                            genX = 0;
                            ++genY;
                        }
                        if (genY >= BiomeDisplayWidget.this.height) {
                            genY = 0;
                            if (full) {
                                BiomeDisplayWidget biomeDisplayWidget = BiomeDisplayWidget.this;
                                // MONITORENTER : biomeDisplayWidget
                                try {
                                    BiomeDisplayWidget.this.wait();
                                }
                                catch (InterruptedException e) {
                                    // MONITOREXIT : biomeDisplayWidget
                                    return;
                                }
                                if (this.stop) {
                                    return;
                                }
                            }
                            full = true;
                        }
                        NativeImage e = BiomeDisplayWidget.this.image;
                        // MONITORENTER : e
                        int baseAlpha = BiomeDisplayWidget.this.image.getPixel(genX, genY) >>> 24;
                        // MONITOREXIT : e
                        if (baseAlpha == 255) continue;
                        full = false;
                        int scale = BiomeDisplayWidget.this.zoomOut.get();
                        int voronoiZoom = BiomeDisplayWidget.this.zoomIn.get();
                        int gridScale = (int)Math.pow(2.0, ((int)(Math.log(scale) / Math.log(2.0)) + 2) / 4 * 4) * voronoiZoom;
                        int intOffX = (int)Math.round(BiomeDisplayWidget.this.offsetX.get());
                        int intOffY = (int)Math.round(BiomeDisplayWidget.this.offsetY.get());
                        int sampleX = (genX + intOffX - BiomeDisplayWidget.this.width / 2) * scale;
                        int sampleY = (genY + intOffY - BiomeDisplayWidget.this.height / 2) * scale;
                        int gridSampleX = sampleX;
                        int gridSampleY = sampleY;
                        if (voronoiZoom > 1) {
                            float voronoiFactor = (float)voronoiZoom * 0.9f;
                            int scaledSampleX = Math.floorDiv(sampleX, voronoiZoom);
                            int scaledSampleY = Math.floorDiv(sampleY, voronoiZoom);
                            int subSampleX = Math.floorMod(sampleX, voronoiZoom);
                            int subSampleY = Math.floorMod(sampleY, voronoiZoom);
                            voronoiRandom.init(scaledSampleX, scaledSampleY);
                            float n00x = ((float)voronoiRandom.nextInt(1024) / 1024.0f - 0.5f) * voronoiFactor;
                            float n00y = ((float)voronoiRandom.nextInt(1024) / 1024.0f - 0.5f) * voronoiFactor;
                            voronoiRandom.init(scaledSampleX + 1, scaledSampleY);
                            float n10x = ((float)voronoiRandom.nextInt(1024) / 1024.0f - 0.5f) * voronoiFactor + (float)voronoiZoom;
                            float n10y = ((float)voronoiRandom.nextInt(1024) / 1024.0f - 0.5f) * voronoiFactor;
                            voronoiRandom.init(scaledSampleX, scaledSampleY + 1);
                            float n01x = ((float)voronoiRandom.nextInt(1024) / 1024.0f - 0.5f) * voronoiFactor;
                            float n01y = ((float)voronoiRandom.nextInt(1024) / 1024.0f - 0.5f) * voronoiFactor + (float)voronoiZoom;
                            voronoiRandom.init(scaledSampleX + 1, scaledSampleY + 1);
                            float n11x = ((float)voronoiRandom.nextInt(1024) / 1024.0f - 0.5f) * voronoiFactor + (float)voronoiZoom;
                            float n11y = ((float)voronoiRandom.nextInt(1024) / 1024.0f - 0.5f) * voronoiFactor + (float)voronoiZoom;
                            sampleX = scaledSampleX;
                            sampleY = scaledSampleY;
                            float dist00 = Mth.square((float)((float)subSampleX - n00x)) + Mth.square((float)((float)subSampleY - n00y));
                            float dist10 = Mth.square((float)((float)subSampleX - n10x)) + Mth.square((float)((float)subSampleY - n10y));
                            float dist01 = Mth.square((float)((float)subSampleX - n01x)) + Mth.square((float)((float)subSampleY - n01y));
                            float dist11 = Mth.square((float)((float)subSampleX - n11x)) + Mth.square((float)((float)subSampleY - n11y));
                            if (dist11 < dist10 && dist11 < dist01 && dist11 < dist00) {
                                ++sampleX;
                                ++sampleY;
                            } else if (dist10 < dist00 && dist10 < dist01 && dist10 < dist11) {
                                ++sampleX;
                            } else if (dist01 < dist00 && dist01 < dist10 && dist01 < dist11) {
                                ++sampleY;
                            }
                        }
                        int step = BiomeDisplayWidget.this.step.get();
                        BiomeProvider subSampleX = ModernBetaBiomePreviewScreen.this.biomeProvider;
                        if (subSampleX instanceof BiomeResolverStepped) {
                            BiomeResolverStepped resolverStepped = (BiomeResolverStepped)((Object)subSampleX);
                            holder = resolverStepped.getBiomeForStep(sampleX, 64, sampleY, step);
                        } else {
                            holder = ModernBetaBiomePreviewScreen.this.biomeProvider.getBiome(sampleX, 64, sampleY);
                        }
                        Holder<Biome> biome = holder;
                        BiomeProvider n00x = ModernBetaBiomePreviewScreen.this.biomeProvider;
                        if (n00x instanceof BiomeResolverExtendedId) {
                            BiomeResolverExtendedId resolverExtendedId = (BiomeResolverExtendedId)((Object)n00x);
                            if (resolverExtendedId instanceof BiomeResolverExtendedIdStepped) {
                                BiomeResolverExtendedIdStepped resolverExtendedIdStepped = (BiomeResolverExtendedIdStepped)resolverExtendedId;
                                extendedBiomeId = resolverExtendedIdStepped.getExtendedBiomeIdForStep(sampleX, 64, sampleY, step);
                            } else {
                                extendedBiomeId = resolverExtendedId.getExtendedBiomeId(sampleX, 64, sampleY);
                            }
                        } else {
                            extendedBiomeId = ExtendedBiomeId.NULL;
                        }
                        ExtendedBiomeId extendedBiome = extendedBiomeId;
                        int color = this.getBiomeColor(biome, extendedBiome.ext(), sampleX, sampleY, (Int2IntMap)randColors, random);
                        if (gridSampleX % (64 * gridScale) == 0 || gridSampleY % (64 * gridScale) == 0) {
                            int r = color >> 16 & 0xFF;
                            int g = color >> 8 & 0xFF;
                            int b = color & 0xFF;
                            r = Mth.lerpInt((float)0.33333334f, (int)r, (int)255);
                            g = Mth.lerpInt((float)0.33333334f, (int)g, (int)255);
                            b = Mth.lerpInt((float)0.33333334f, (int)b, (int)255);
                            color = r << 16 | g << 8 | b;
                        } else if (gridSampleX % (4 * gridScale) == 0 || gridSampleY % (4 * gridScale) == 0) {
                            int r = color >> 16 & 0xFF;
                            int g = color >> 8 & 0xFF;
                            int b = color & 0xFF;
                            r = Mth.lerpInt((float)0.1f, (int)r, (int)255);
                            g = Mth.lerpInt((float)0.1f, (int)g, (int)255);
                            b = Mth.lerpInt((float)0.1f, (int)b, (int)255);
                            color = r << 16 | g << 8 | b;
                        }
                        NativeImage nativeImage = BiomeDisplayWidget.this.image;
                        // MONITORENTER : nativeImage
                        BiomeDisplayWidget.this.image.setPixel(genX, genY, color |= 0xFF000000);
                        this.uploadRequested = true;
                        // MONITOREXIT : nativeImage
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    ModernBetaBiomePreviewScreen.this.exceptionMessage = exception.getLocalizedMessage();
                }
            }

            private int getBiomeColor(Holder<Biome> biomeEntry, String ext, int x, int y, Int2IntMap randColors, Random random) {
                int color;
                boolean watery;
                Integer registeredColor;
                String id = biomeEntry.unwrapKey().map(key -> key.location().toString()).orElse("[unregistered]");
                if (ext != null && !ext.isEmpty()) {
                    String extId = id + "*" + ext;
                    Integer registeredExtColor = ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_BIOME_PREVIEW_COLORS).get(extId);
                    if (registeredExtColor != null) {
                        return registeredExtColor;
                    }
                    Matcher extIntMatcher = EXT_INT.matcher(ext);
                    if (extIntMatcher.find()) {
                        try {
                            int extInt = Integer.parseInt(extIntMatcher.group());
                            return extInt >= 256 ? extInt : randColors.computeIfAbsent(Integer.parseInt(extIntMatcher.group()), i -> random.nextInt(0xFFFFFF));
                        }
                        catch (Exception extInt) {
                            // empty catch block
                        }
                    }
                }
                if ((registeredColor = ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_BIOME_PREVIEW_COLORS).get(id)) != null) {
                    return registeredColor;
                }
                Biome biome = (Biome)biomeEntry.value();
                boolean bl = watery = biomeEntry.is(BiomeTags.IS_OCEAN) || biomeEntry.is(BiomeTags.IS_RIVER);
                if (watery) {
                    color = biome.getWaterColor();
                    if (biomeEntry.is(BiomeTags.IS_OCEAN)) {
                        color = (color & 0xFEFEFE) >> 1;
                        if (biomeEntry.is(BiomeTags.IS_DEEP_OCEAN)) {
                            color = (color & 0xFEFEFE) >> 1;
                        }
                    }
                } else {
                    SurfaceConfig surfaceConfig = SurfaceConfig.getSurfaceConfig(biomeEntry);
                    BlockState topBlock = surfaceConfig.normal().topBlock();
                    color = topBlock.is(Blocks.GRASS_BLOCK) ? biome.getGrassColor((double)x, (double)y) : topBlock.getMapColor(null, (BlockPos)new BlockPos((int)x, (int)64, (int)y)).col;
                }
                float contrast = 2.0f;
                float[] hsb = new float[3];
                Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, hsb);
                hsb[1] = Mth.clamp((float)(hsb[1] * contrast), (float)0.0f, (float)1.0f);
                hsb[2] = Mth.clamp((float)((hsb[2] - 0.5f) * contrast + 0.5f), (float)0.0f, (float)1.0f);
                if (biome.getBaseTemperature() < 0.15f && !biomeEntry.is(BiomeTags.IS_DEEP_OCEAN)) {
                    hsb[1] = hsb[1] * 0.1f;
                    hsb[2] = hsb[2] * 0.25f + 0.75f;
                }
                return Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            }
        }
    }
}

