/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ModernBetaSelectBiomeScreen
extends Screen {
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final Screen parent;
    private final Consumer<Holder<Biome>> onDone;
    private final boolean allowNone;
    final Registry<Biome> biomeRegistry;
    private BiomeListWidget biomeSelectionList;
    Holder<Biome> biome;
    private Button confirmButton;

    public ModernBetaSelectBiomeScreen(Screen parent, WorldCreationContext generatorOptionsHolder, Consumer<Holder<Biome>> onDone, boolean allowNone) {
        super((Component)Component.translatable((String)"createWorld.customize.modern_beta.title.biome_picker"));
        this.parent = parent;
        this.onDone = onDone;
        this.allowNone = allowNone;
        this.biomeRegistry = generatorOptionsHolder.worldgenLoadContext().lookupOrThrow(Registries.BIOME);
        Holder registryEntry = (Holder)this.biomeRegistry.get(Biomes.PLAINS).or(() -> this.biomeRegistry.listElements().findAny()).orElseThrow();
        this.biome = generatorOptionsHolder.selectedDimensions().overworld().getBiomeSource().possibleBiomes().stream().findFirst().orElse(registryEntry);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    protected void init() {
        LinearLayout header = (LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.vertical().spacing(8));
        header.defaultCellSetting().alignHorizontallyCenter();
        header.addChild((LayoutElement)new StringWidget(this.getTitle(), this.font));
        this.biomeSelectionList = (BiomeListWidget)this.layout.addToContents((LayoutElement)new BiomeListWidget());
        LinearLayout footer = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        this.confirmButton = (Button)footer.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.onDone.accept(this.biome);
            this.onClose();
        }).build());
        footer.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).build());
        this.biomeSelectionList.setSelected((BiomeListWidget.BiomeItem)this.biomeSelectionList.children().stream().filter(entry -> Objects.equals(entry.biome, this.biome)).findFirst().orElse(null));
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        this.biomeSelectionList.updateSize(this.width, this.layout);
    }

    void refreshConfirmButton() {
        this.confirmButton.active = this.biomeSelectionList.getSelected() != null;
    }

    class BiomeListWidget
    extends ObjectSelectionList<BiomeItem> {
        BiomeListWidget() {
            super(ModernBetaSelectBiomeScreen.this.minecraft, ModernBetaSelectBiomeScreen.this.width, ModernBetaSelectBiomeScreen.this.height - 77, 40, 16);
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());
            if (ModernBetaSelectBiomeScreen.this.allowNone) {
                this.addEntry((AbstractSelectionList.Entry)new BiomeItem());
            }
            ModernBetaSelectBiomeScreen.this.biomeRegistry.listElements().map(x$0 -> new BiomeItem((Holder.Reference<Biome>)x$0)).sorted(Comparator.comparing(biome -> biome.text.getString(), collator)).forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
        }

        public void setSelected(@Nullable BiomeItem buffetBiomeItem) {
            super.setSelected((AbstractSelectionList.Entry)buffetBiomeItem);
            if (buffetBiomeItem != null) {
                ModernBetaSelectBiomeScreen.this.biome = buffetBiomeItem.biome;
            }
            ModernBetaSelectBiomeScreen.this.refreshConfirmButton();
        }

        class BiomeItem
        extends ObjectSelectionList.Entry<BiomeItem> {
            final Holder.Reference<Biome> biome;
            final Component text;

            public BiomeItem() {
                this.biome = null;
                this.text = Component.translatable((String)"gui.none").withStyle(ChatFormatting.ITALIC);
            }

            public BiomeItem(Holder.Reference<Biome> biome) {
                this.biome = biome;
                ResourceLocation id = biome.key().location();
                String name = id.toLanguageKey("biome");
                this.text = Language.getInstance().has(name) ? Component.translatable((String)name) : Component.literal((String)id.toString());
            }

            public Component getNarration() {
                return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.text});
            }

            public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                context.drawString(ModernBetaSelectBiomeScreen.this.font, this.text, x + 5, y + 2, -1);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                BiomeListWidget.this.setSelected(this);
                return super.mouseClicked(mouseX, mouseY, button);
            }
        }
    }
}

