/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen;

import java.util.List;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaWorldScreen;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPresetCategory;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModernBetaSettingsPresetScreen
extends ModernBetaScreen {
    private static final String TEXT_TITLE = "createWorld.customize.modern_beta.title.preset";
    private static final String TEXT_PRESET_NAME = "createWorld.customize.modern_beta.preset.name";
    private static final String TEXT_PRESET_DESC = "createWorld.customize.modern_beta.preset.desc";
    private static final String TEXT_PRESET_CATEGORY_NAME = "createWorld.customize.modern_beta.preset_category.name";
    private static final String TEXT_PRESET_CATEGORY_DESC = "createWorld.customize.modern_beta.preset_category.desc";
    private static final ResourceLocation TEXTURE_PRESET_CUSTOM = ModernBetaSettingsPresetScreen.createTextureId(ModernerBeta.createId("custom"));
    private final ModernBetaWorldScreen worldScreen;
    private final List<ResourceLocation> presets;
    private final boolean displayCategories;
    private final Registry<ModernBetaSettingsPreset> presetRegistry;
    private final Registry<ModernBetaSettingsPresetCategory> presetCategoryRegistry;
    private ModernBetaSettingsPreset preset;
    private PresetsListWidget listWidget;
    private Button selectPresetButton;

    public ModernBetaSettingsPresetScreen(ModernBetaScreen parent, Registry<ModernBetaSettingsPreset> presetRegistry, Registry<ModernBetaSettingsPresetCategory> presetCategoryRegistry, List<ResourceLocation> presets, ModernBetaSettingsPreset preset, boolean displayCategories) {
        super((Component)Component.translatable((String)TEXT_TITLE), parent);
        this.presets = presets;
        this.preset = preset;
        this.displayCategories = displayCategories;
        this.presetRegistry = presetRegistry;
        this.presetCategoryRegistry = presetCategoryRegistry;
        ModernBetaScreen worldScreen = parent;
        while (!(worldScreen instanceof ModernBetaWorldScreen)) {
            if (!(worldScreen instanceof ModernBetaScreen)) {
                worldScreen = null;
                break;
            }
            ModernBetaScreen modernBetaScreen = worldScreen;
            worldScreen = modernBetaScreen.parent;
        }
        this.worldScreen = (ModernBetaWorldScreen)worldScreen;
    }

    @Override
    protected void init() {
        super.init();
        this.listWidget = new PresetsListWidget(this.presets);
        this.addWidget((GuiEventListener)this.listWidget);
        this.selectPresetButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"createWorld.customize.presets.select"), onPress -> {
            this.worldScreen.setPreset(this.preset);
            this.minecraft.setScreen(this.parent);
        }).bounds(this.width / 2 - 154, this.height - 26, 150, 20).build());
        this.selectPresetButton.active = !this.displayCategories;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)(this.displayCategories ? CommonComponents.GUI_CANCEL : CommonComponents.GUI_BACK), button -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 + 4, this.height - 26, 150, 20).build());
        this.updateSelectButton(this.listWidget.getSelected() instanceof PresetsListWidget.PresetEntry);
    }

    @Override
    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.listWidget.render(context, mouseX, mouseY, delta);
    }

    private void updateSelectButton(boolean hasSelected) {
        this.selectPresetButton.active = hasSelected;
    }

    private static ResourceLocation createTextureId(ResourceLocation id) {
        return id.withPath("textures/gui/moderner_beta_settings_preset/" + id.getPath() + ".png");
    }

    private static ResourceLocation createPresetTextureId(ResourceLocation id) {
        ResourceLocation idObj = ModernBetaSettingsPresetScreen.createTextureId(id);
        return Minecraft.getInstance().getResourceManager().getResource(idObj).isPresent() ? idObj : TEXTURE_PRESET_CUSTOM;
    }

    private class PresetsListWidget
    extends ObjectSelectionList<AbstractPresetEntry> {
        private static final int ITEM_HEIGHT = 60;
        private static final int ICON_SIZE = 56;
        private static final int SCROLLBAR_X_OFFSET = 30;

        public PresetsListWidget(List<ResourceLocation> presets) {
            super(ModernBetaSettingsPresetScreen.this.minecraft, ModernBetaSettingsPresetScreen.this.width, ModernBetaSettingsPresetScreen.this.height - 64, 32, 60);
            if (ModernBetaSettingsPresetScreen.this.displayCategories) {
                presets.forEach(key -> this.addEntry((AbstractSelectionList.Entry)new PresetCategoryEntry((ResourceLocation)key, (ModernBetaSettingsPresetCategory)ModernBetaSettingsPresetScreen.this.presetCategoryRegistry.getValue(key))));
            } else {
                presets.forEach(key -> this.addEntry((AbstractSelectionList.Entry)new PresetEntry((ResourceLocation)key)));
            }
        }

        public void setSelected(AbstractPresetEntry entry) {
            super.setSelected((AbstractSelectionList.Entry)entry);
            ModernBetaSettingsPresetScreen.this.updateSelectButton(entry instanceof PresetEntry);
        }

        protected int scrollBarX() {
            return super.scrollBarX() + 30;
        }

        public int getRowWidth() {
            return super.getRowWidth() + 85;
        }

        private class PresetEntry
        extends AbstractPresetEntry {
            private final ResourceLocation key;

            public PresetEntry(ResourceLocation presetName) {
                super(presetName);
                this.key = presetName;
            }

            @Override
            protected void setPreset() {
                PresetsListWidget.this.setSelected(this);
                ModernBetaSettingsPresetScreen.this.preset = ModernBetaSettingsPreset.referenced(this.key);
            }

            @Override
            protected void selectPreset() {
                Screen screen;
                ModernBetaSettingsPresetScreen presetScreen = ModernBetaSettingsPresetScreen.this;
                Minecraft minecraftClient = presetScreen.minecraft;
                minecraftClient.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                presetScreen.worldScreen.setPreset(ModernBetaSettingsPreset.referenced(this.key));
                while ((screen = minecraftClient.screen) instanceof ModernBetaSettingsPresetScreen) {
                    ModernBetaSettingsPresetScreen subPresetScreen = (ModernBetaSettingsPresetScreen)screen;
                    minecraftClient.setScreen(subPresetScreen.parent);
                }
            }
        }

        private abstract class AbstractPresetEntry
        extends ObjectSelectionList.Entry<AbstractPresetEntry> {
            private static final ResourceLocation TEXTURE_JOIN = VersionCompat.vanillaId("world_list/join");
            private static final ResourceLocation TEXTURE_JOIN_HIGHLIGHTED = VersionCompat.vanillaId("world_list/join_highlighted");
            private static final int TEXT_SPACING = 11;
            private static final int TEXT_LENGTH = 240;
            private final ResourceLocation presetTexture;
            private final MutableComponent presetName;
            private final MutableComponent presetDesc;
            private long time;

            public AbstractPresetEntry(ResourceLocation presetName) {
                this.presetTexture = this.getPresetTexture(presetName);
                this.presetName = this.getPresetName(presetName);
                this.presetDesc = this.getPresetDesc(presetName);
            }

            protected abstract void setPreset();

            protected abstract void selectPreset();

            protected ResourceLocation getPresetTexture(ResourceLocation presetName) {
                return ModernBetaSettingsPresetScreen.createPresetTextureId(presetName);
            }

            protected MutableComponent getPresetName(ResourceLocation presetName) {
                return Component.translatable((String)("createWorld.customize.modern_beta.preset.name." + presetName.toLanguageKey()));
            }

            protected MutableComponent getPresetDesc(ResourceLocation presetName) {
                return Component.translatable((String)("createWorld.customize.modern_beta.preset.desc." + presetName.toLanguageKey()));
            }

            protected ChatFormatting getTextFormatting() {
                return ChatFormatting.YELLOW;
            }

            public Component getNarration() {
                return Component.empty();
            }

            public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                MutableComponent presetNameText = this.presetName.withStyle(this.getTextFormatting());
                List<FormattedCharSequence> presetDescTexts = this.splitText(ModernBetaSettingsPresetScreen.this.font, (Component)this.presetDesc);
                int textStartX = x + 56 + 3;
                int textStartY = 1;
                context.drawString(ModernBetaSettingsPresetScreen.this.font, (Component)presetNameText, textStartX, y + textStartY, -1, false);
                int descSpacing = 11 + textStartY + 1;
                for (FormattedCharSequence line : presetDescTexts) {
                    context.drawString(ModernBetaSettingsPresetScreen.this.font, line, textStartX, y + descSpacing, -8355712, false);
                    descSpacing += 11;
                }
                this.draw(context, x, y, this.presetTexture);
                if (PresetsListWidget.this.minecraft != null && ((Boolean)((PresetsListWidget)PresetsListWidget.this).minecraft.options.touchscreen().get()).booleanValue() || hovered) {
                    boolean isMouseHovering = mouseX - x < 56;
                    context.fill(x, y, x + 56, y + 56, -1601138544);
                    ResourceLocation texture = isMouseHovering ? TEXTURE_JOIN_HIGHLIGHTED : TEXTURE_JOIN;
                    context.blitSprite(RenderType::guiTextured, texture, x, y, 56, 56);
                }
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (button != 0) {
                    return false;
                }
                this.setPreset();
                if (mouseX - (double)PresetsListWidget.this.getRowLeft() <= 56.0) {
                    this.selectPreset();
                }
                if (Util.getMillis() - this.time < 250L) {
                    this.selectPreset();
                }
                this.time = Util.getMillis();
                return true;
            }

            private void draw(GuiGraphics context, int x, int y, ResourceLocation textureId) {
                context.blit(RenderType::guiTextured, textureId, x, y, 0.0f, 0.0f, 56, 56, 56, 56);
            }

            private List<FormattedCharSequence> splitText(Font textRenderer, Component text) {
                return textRenderer.split((FormattedText)text, 240);
            }
        }

        private class PresetCategoryEntry
        extends AbstractPresetEntry {
            private final ModernBetaSettingsPresetCategory presetCategory;

            public PresetCategoryEntry(ResourceLocation presetName, ModernBetaSettingsPresetCategory presetCategory) {
                super(presetName);
                this.presetCategory = presetCategory;
            }

            @Override
            protected ResourceLocation getPresetTexture(ResourceLocation presetName) {
                presetName = ((ModernBetaSettingsPresetCategory)ModernBetaSettingsPresetScreen.this.presetCategoryRegistry.getValue(presetName)).defaultIcon();
                return super.getPresetTexture(presetName);
            }

            @Override
            protected MutableComponent getPresetName(ResourceLocation presetName) {
                return Component.translatable((String)("createWorld.customize.modern_beta.preset_category.name." + presetName.toLanguageKey()));
            }

            @Override
            protected MutableComponent getPresetDesc(ResourceLocation presetName) {
                return Component.translatable((String)("createWorld.customize.modern_beta.preset_category.desc." + presetName.toLanguageKey()));
            }

            @Override
            protected ChatFormatting getTextFormatting() {
                return ChatFormatting.AQUA;
            }

            @Override
            protected void setPreset() {
                PresetsListWidget.this.setSelected(this);
            }

            @Override
            protected void selectPreset() {
                assert (PresetsListWidget.this.minecraft != null);
                PresetsListWidget.this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                PresetsListWidget.this.minecraft.setScreen((Screen)new ModernBetaSettingsPresetScreen(ModernBetaSettingsPresetScreen.this, ModernBetaSettingsPresetScreen.this.presetRegistry, ModernBetaSettingsPresetScreen.this.presetCategoryRegistry, this.presetCategory.presets(), ModernBetaSettingsPresetScreen.this.preset, false));
            }
        }
    }
}

