/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.function.Consumer;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaScreen;
import mod.bluestaggo.modernerbeta.mixin.client.AccessorEditBoxWidget;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModernBetaSettingsScreen
extends ModernBetaScreen {
    private static final String TEXT_NAVIGATION = "createWorld.customize.modern_beta.navigation";
    private static final String TEXT_SETTINGS = "createWorld.customize.modern_beta.settings";
    private static final String TEXT_SETTINGS_SAVE = "createWorld.customize.modern_beta.settings.save";
    private static final String TEXT_INVALID_JSON = "createWorld.customize.modern_beta.invalid_json";
    private final Consumer<String> onDone;
    private final Gson gson;
    private String settingsString;
    private Button widgetDone;
    private MultiLineEditBox widgetSettings;
    private StringWidget widgetInvalid;

    public ModernBetaSettingsScreen(String title, Screen parent, ModernBetaSettings settings, Consumer<String> onDone) {
        super((Component)Component.translatable((String)title), parent);
        this.onDone = onDone;
        this.gson = ModernerBeta.getSettingsGson().setPrettyPrinting().create();
        this.settingsString = this.gson.toJson((JsonElement)VersionCompat.getOrThrow(ModernBetaSettings.CODEC.encode((Object)settings, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject())));
    }

    @Override
    protected void init() {
        super.init();
        this.widgetDone = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS_SAVE), button -> {
            this.onDone.accept(this.settingsString);
            this.minecraft.setScreen(this.parent);
        }).bounds(this.width / 2 - 154, this.height - 26, 150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.widgetDone);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 + 4, this.height - 26, 150, 20).build());
        int editBoxWidth = this.width - 16;
        int editBoxHeight = this.height - 96;
        this.widgetSettings = new MultiLineEditBox(this.font, 0, 0, editBoxWidth, editBoxHeight, Component.nullToEmpty((String)""), (Component)Component.translatable((String)TEXT_SETTINGS));
        this.widgetSettings.setValue(this.settingsString);
        this.widgetSettings.setValueListener(string -> {
            this.settingsString = string;
            this.onChange();
        });
        MutableComponent textInvalid = Component.translatable((String)TEXT_INVALID_JSON).withStyle(ChatFormatting.RED);
        this.widgetInvalid = new StringWidget((Component)textInvalid, this.font);
        MutableComponent textNavigation = Component.translatable((String)TEXT_NAVIGATION);
        StringWidget widgetNavigation = new StringWidget((Component)textNavigation, this.font);
        GridLayout gridWidget = this.createGridWidget();
        GridLayout.RowHelper gridWidgetAdder = gridWidget.createRowHelper(1);
        gridWidgetAdder.addChild((LayoutElement)widgetNavigation);
        gridWidgetAdder.addChild((LayoutElement)this.widgetSettings);
        gridWidgetAdder.addChild((LayoutElement)this.widgetInvalid);
        gridWidget.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)gridWidget, (int)0, (int)(this.overlayTop + 8), (int)this.width, (int)this.height, (float)0.5f, (float)0.0f);
        gridWidget.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        MultilineTextField editBox = ((AccessorEditBoxWidget)this.widgetSettings).getEditBox();
        editBox.seekCursor(Whence.ABSOLUTE, 0);
        this.onChange();
    }

    private void onChange() {
        boolean isValid;
        this.widgetDone.active = isValid = this.isValidJson(this.settingsString);
        this.widgetInvalid.visible = !isValid;
    }

    private boolean isValidJson(String json) {
        try {
            JsonParser.parseString((String)json);
        }
        catch (JsonSyntaxException e) {
            return false;
        }
        return true;
    }
}

