/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen;

import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaBiomePreviewScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaSettingsConfirmScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaSettingsPresetScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaSettingsScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.ModernBetaGraphicalProviderSettingsScreen;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistryKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPresetCategory;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.tags.ModernBetaSettingsPresetCategoryTags;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.TriConsumer;

@OnlyIn(value=Dist.CLIENT)
public class ModernBetaWorldScreen
extends ModernBetaScreen {
    private static final String TEXT_TITLE = "createWorld.customize.modern_beta.title";
    private static final String TEXT_TITLE_CHUNK = "createWorld.customize.modern_beta.title.chunk";
    private static final String TEXT_TITLE_BIOME = "createWorld.customize.modern_beta.title.biome";
    private static final String TEXT_TITLE_CAVE_BIOME = "createWorld.customize.modern_beta.title.cave_biome";
    private static final String TEXT_PRESET = "createWorld.customize.modern_beta.preset";
    private static final String TEXT_PRESET_NAME = "createWorld.customize.modern_beta.preset.name";
    private static final String TEXT_PRESET_CUSTOM = "createWorld.customize.modern_beta.preset.custom";
    private static final String TEXT_CHUNK = "createWorld.customize.modern_beta.chunk";
    private static final String TEXT_BIOME = "createWorld.customize.modern_beta.biome";
    private static final String TEXT_CAVE_BIOME = "createWorld.customize.modern_beta.cave_biome";
    private static final String TEXT_SETTINGS = "createWorld.customize.modern_beta.settings";
    private static final String TEXT_SETTINGS_JSON = "createWorld.customize.modern_beta.settings.json";
    private static final String TEXT_SETTINGS_RESET = "createWorld.customize.modern_beta.settings.reset";
    private static final String TEXT_SETTINGS_RESET_MESSAGE = "createWorld.customize.modern_beta.settings.reset.message";
    private static final String TEXT_SETTINGS_PREVIEW = "createWorld.customize.modern_beta.settings.preview";
    private static final String[] TEXT_HINTS = new String[]{"createWorld.customize.modern_beta.hint.settings"};
    private final TriConsumer<CompoundTag, CompoundTag, CompoundTag> onDone;
    private final String hintString;
    private final WorldCreationContext generatorOptionsHolder;
    private final Registry<ModernBetaSettingsPreset> presetRegistry;
    private final Registry<ModernBetaSettingsPresetCategory> presetCategoryRegistry;
    private ModernBetaSettingsPreset preset;
    private Button buttonPreset;

    public ModernBetaWorldScreen(Screen parent, WorldCreationContext generatorOptionsHolder, TriConsumer<CompoundTag, CompoundTag, CompoundTag> onDone) {
        super((Component)Component.translatable((String)TEXT_TITLE), parent);
        ChunkGenerator chunkGenerator = generatorOptionsHolder.selectedDimensions().overworld();
        ModernBetaChunkGenerator modernBetaChunkGenerator = (ModernBetaChunkGenerator)chunkGenerator;
        ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)modernBetaChunkGenerator.getBiomeSource();
        this.presetRegistry = generatorOptionsHolder.worldgenLoadContext().lookupOrThrow(ModernBetaRegistryKeys.SETTINGS_PRESET);
        this.presetCategoryRegistry = generatorOptionsHolder.worldgenLoadContext().lookupOrThrow(ModernBetaRegistryKeys.SETTINGS_PRESET_CATEGORY);
        this.onDone = onDone;
        this.hintString = TEXT_HINTS[new Random().nextInt(TEXT_HINTS.length)];
        this.preset = new ModernBetaSettingsPreset(modernBetaChunkGenerator.getChunkSettings(), modernBetaBiomeSource.getBiomeSettings(), modernBetaBiomeSource.getCaveBiomeSettings());
        this.generatorOptionsHolder = generatorOptionsHolder;
    }

    public void setPreset(ModernBetaSettingsPreset preset) {
        this.preset = preset;
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.onDone.accept((Object)this.preset.chunkSettings().toCompound(), (Object)this.preset.biomeSettings().toCompound(), (Object)this.preset.caveBiomeSettings().toCompound());
            this.minecraft.setScreen(this.parent);
        }).bounds(this.width / 2 - 154, this.height - 26, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 + 4, this.height - 26, 150, 20).build());
        MutableComponent hintText = Component.translatable((String)this.hintString).withStyle(ChatFormatting.GRAY);
        int hintTextWidth = this.font.width(hintText.getVisualOrderText());
        Objects.requireNonNull(this.font);
        int hintTextHeight = 9;
        this.addRenderableWidget((GuiEventListener)new StringWidget(this.width / 2 - hintTextWidth / 2, this.height - 46, hintTextWidth, hintTextHeight, (Component)hintText, this.font));
        MutableComponent presetText = Component.translatable((String)TEXT_PRESET).append(": ");
        ResourceLocation presetKey = this.getPresetKey();
        presetText.append((Component)(presetKey == null ? Component.translatable((String)TEXT_PRESET_CUSTOM).withStyle(ChatFormatting.AQUA) : Component.translatable((String)("createWorld.customize.modern_beta.preset.name." + presetKey.toLanguageKey())).withStyle(ChatFormatting.YELLOW)));
        this.buttonPreset = Button.builder((Component)presetText, button -> this.minecraft.setScreen((Screen)new ModernBetaSettingsPresetScreen(this, this.presetRegistry, this.presetCategoryRegistry, this.presetCategoryRegistry.getOrThrow(ModernBetaSettingsPresetCategoryTags.SELECTABLE).stream().map(Holder::unwrapKey).flatMap(Optional::stream).map(ResourceKey::location).toList(), this.preset, true))).bounds(0, 0, 200, 20).build();
        Registry<ModernBetaSettingsPreset> presetLookup = this.presetRegistry;
        Button buttonChunk = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS), button -> this.minecraft.setScreen((Screen)new ModernBetaGraphicalProviderSettingsScreen(TEXT_TITLE_CHUNK, (Screen)this, this.generatorOptionsHolder, this.preset.chunkSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::chunkSettings).toCompound(), nbtCompound -> {
            Tuple<ModernBetaSettingsPreset, Boolean> updatedPreset = this.preset.setNbt((CompoundTag)nbtCompound, null, null);
            this.preset = (ModernBetaSettingsPreset)updatedPreset.getA();
        }, ModernBetaRegistries.CHUNK))).build();
        Button buttonChunkAdvanced = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS_JSON), button -> this.minecraft.setScreen((Screen)new ModernBetaSettingsScreen(TEXT_TITLE_CHUNK, this, this.preset.chunkSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::chunkSettings), string -> {
            Tuple<ModernBetaSettingsPreset, Boolean> updatedPreset = this.preset.setJson((String)string, "", "");
            this.preset = (ModernBetaSettingsPreset)updatedPreset.getA();
        }))).size(20, 20).build();
        Button buttonBiome = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS), button -> this.minecraft.setScreen((Screen)new ModernBetaGraphicalProviderSettingsScreen(TEXT_TITLE_CHUNK, (Screen)this, this.generatorOptionsHolder, this.preset.biomeSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::biomeSettings).toCompound(), nbtCompound -> {
            Tuple<ModernBetaSettingsPreset, Boolean> updatedPreset = this.preset.setNbt(null, (CompoundTag)nbtCompound, null);
            this.preset = (ModernBetaSettingsPreset)updatedPreset.getA();
        }, ModernBetaRegistries.BIOME))).build();
        Button buttonBiomeAdvanced = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS_JSON), button -> this.minecraft.setScreen((Screen)new ModernBetaSettingsScreen(TEXT_TITLE_BIOME, this, this.preset.biomeSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::biomeSettings), string -> {
            Tuple<ModernBetaSettingsPreset, Boolean> updatedPreset = this.preset.setJson("", (String)string, "");
            this.preset = (ModernBetaSettingsPreset)updatedPreset.getA();
        }))).size(20, 20).build();
        Button buttonCaveBiome = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS), button -> this.minecraft.setScreen((Screen)new ModernBetaGraphicalProviderSettingsScreen(TEXT_TITLE_CHUNK, (Screen)this, this.generatorOptionsHolder, this.preset.caveBiomeSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::caveBiomeSettings).toCompound(), nbtCompound -> {
            Tuple<ModernBetaSettingsPreset, Boolean> updatedPreset = this.preset.setNbt(null, null, (CompoundTag)nbtCompound);
            this.preset = (ModernBetaSettingsPreset)updatedPreset.getA();
        }, ModernBetaRegistries.CAVE_BIOME))).build();
        Button buttonCaveBiomeAdvanced = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS_JSON), button -> this.minecraft.setScreen((Screen)new ModernBetaSettingsScreen(TEXT_TITLE_CAVE_BIOME, this, this.preset.caveBiomeSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::caveBiomeSettings), string -> {
            Tuple<ModernBetaSettingsPreset, Boolean> updatedPreset = this.preset.setJson("", "", (String)string);
            this.preset = (ModernBetaSettingsPreset)updatedPreset.getA();
        }))).size(20, 20).build();
        Button buttonReset = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS_RESET), button -> this.minecraft.setScreen((Screen)new ModernBetaSettingsConfirmScreen(this, this::resetPreset, (Component)Component.translatable((String)TEXT_SETTINGS_RESET_MESSAGE), (Component)Component.translatable((String)TEXT_SETTINGS_RESET)))).build();
        Button buttonPreview = Button.builder((Component)Component.translatable((String)TEXT_SETTINGS_PREVIEW), button -> this.minecraft.setScreen((Screen)new ModernBetaBiomePreviewScreen((Component)Component.translatable((String)TEXT_SETTINGS_PREVIEW), this, this.generatorOptionsHolder, this.preset.biomeSettings().mapPreset((HolderGetter<ModernBetaSettingsPreset>)presetLookup, ModernBetaSettingsPreset::biomeSettings)))).build();
        GridLayout gridWidgetMain = this.createGridWidget();
        GridLayout gridWidgetSettings = this.createGridWidget();
        GridLayout gridWidgetActions = this.createGridWidget();
        GridLayout.RowHelper gridAdderMain = gridWidgetMain.createRowHelper(1);
        GridLayout.RowHelper gridAdderSettings = gridWidgetSettings.createRowHelper(3);
        GridLayout.RowHelper gridAdderActions = gridWidgetActions.createRowHelper(2);
        gridAdderSettings.defaultCellSetting().alignVerticallyMiddle();
        gridAdderMain.addChild((LayoutElement)this.buttonPreset);
        gridAdderMain.addChild((LayoutElement)gridWidgetSettings);
        gridAdderMain.addChild((LayoutElement)gridWidgetActions);
        this.addGridTextButtonTriplet(gridAdderSettings, TEXT_CHUNK, buttonChunk, buttonChunkAdvanced);
        this.addGridTextButtonTriplet(gridAdderSettings, TEXT_BIOME, buttonBiome, buttonBiomeAdvanced);
        this.addGridTextButtonTriplet(gridAdderSettings, TEXT_CAVE_BIOME, buttonCaveBiome, buttonCaveBiomeAdvanced);
        gridAdderActions.addChild((LayoutElement)buttonReset);
        gridAdderActions.addChild((LayoutElement)buttonPreview);
        gridWidgetMain.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)gridWidgetMain, (int)0, (int)(this.overlayTop + 8), (int)this.width, (int)this.height, (float)0.5f, (float)0.0f);
        gridWidgetMain.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    private void resetPreset() {
        this.preset = ModernBetaSettingsPreset.referenced(ModernBetaSettings.DEFAULT_PRESET_ID);
    }

    private ResourceLocation getPresetKey() {
        ResourceLocation presetKey = null;
        for (ModernBetaSettings settings : this.preset.asList()) {
            ResourceLocation subPresetKey = settings.get(SettingsComponentTypes.PRESET);
            if (ModernBetaSettings.DEFAULT_PRESET_ID.equals((Object)subPresetKey)) {
                subPresetKey = ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_MISCELLANEOUS).defaultSettingsPreset();
            }
            if (subPresetKey == null || presetKey != null && !presetKey.equals((Object)subPresetKey)) {
                return null;
            }
            presetKey = subPresetKey;
        }
        return presetKey;
    }
}

