/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen;

import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistryKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModernBetaWorldScreenProvider {
    public static WorldCreationContext.DimensionsUpdater createModifier(CompoundTag chunkSettingsCompound, CompoundTag biomeSettingsCompound, CompoundTag caveBiomeSettingsCompound) {
        return (dynamicRegistryManager, dimensionsRegistryHolder) -> {
            Registry registryPreset = dynamicRegistryManager.lookupOrThrow(ModernBetaRegistryKeys.SETTINGS_PRESET);
            ModernBetaSettings chunkSettings = ModernBetaSettings.fromCompound(chunkSettingsCompound).mapPreset((HolderGetter<ModernBetaSettingsPreset>)registryPreset, ModernBetaSettingsPreset::chunkSettings);
            ResourceKey<NoiseGeneratorSettings> modernBetaSettings = ModernBetaWorldScreenProvider.keyOfSettings(chunkSettings.getProvider());
            Registry registrySettings = dynamicRegistryManager.lookupOrThrow(Registries.NOISE_SETTINGS);
            Holder.Reference settings = registrySettings.getOrThrow(modernBetaSettings);
            Registry registryBiome = dynamicRegistryManager.lookupOrThrow(Registries.BIOME);
            ModernBetaChunkGenerator chunkGenerator = new ModernBetaChunkGenerator(new ModernBetaBiomeSource((HolderGetter<Biome>)registryBiome, (HolderGetter<ModernBetaSettingsPreset>)registryPreset, biomeSettingsCompound, caveBiomeSettingsCompound), (HolderGetter<ModernBetaSettingsPreset>)registryPreset, (Holder<NoiseGeneratorSettings>)settings, chunkSettingsCompound);
            return dimensionsRegistryHolder.replaceOverworldGenerator((HolderLookup.Provider)dynamicRegistryManager, (ChunkGenerator)chunkGenerator);
        };
    }

    private static ResourceKey<NoiseGeneratorSettings> keyOfSettings(ResourceLocation id) {
        return ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)id);
    }
}

