/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen.config;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.Consumer;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.GraphicalConfigBuilder;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.ModernBetaGraphicalCompoundSettingsScreen;
import mod.bluestaggo.modernerbeta.client.registry.ModernBetaClientRegistries;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentType;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;

public abstract class ModernBetaGraphicalComponentedSettingsScreen
extends ModernBetaGraphicalCompoundSettingsScreen {
    private ResourceLocation currentComponentType;

    public ModernBetaGraphicalComponentedSettingsScreen(String title, Screen parent, WorldCreationContext generatorOptionsHolder, String type, CompoundTag settings, Consumer<CompoundTag> onDone) {
        super(title, parent, generatorOptionsHolder, type, settings, onDone);
    }

    protected String getCurrentComponentTypeAsString() {
        Object currentComponentTypeString = this.currentComponentType.getPath();
        if (!this.currentComponentType.getNamespace().equals("moderner_beta")) {
            currentComponentTypeString = this.currentComponentType.getNamespace() + "." + (String)currentComponentTypeString;
        }
        return currentComponentTypeString;
    }

    @Override
    protected Tuple<CompoundTag, String> resolveSettings(String key) {
        if (this.currentComponentType != null) {
            if ("self".equals(key)) {
                return new Tuple((Object)((CompoundTag)this.settings), (Object)this.currentComponentType.toString());
            }
            key = ((String)key).isEmpty() ? this.currentComponentType.toString() : String.valueOf(this.currentComponentType) + "." + (String)key;
        }
        return super.resolveSettings((String)key);
    }

    @Override
    protected String getTextKey(String key, String subKey) {
        int colon;
        Object text = "createWorld.customize.modern_beta.settings.";
        if (this.currentComponentType != null) {
            Object currentComponentTypeString = this.currentComponentType.getPath();
            if (!this.currentComponentType.getNamespace().equals("moderner_beta")) {
                currentComponentTypeString = this.currentComponentType.getNamespace() + "." + (String)currentComponentTypeString;
            }
            text = (String)text + (String)currentComponentTypeString + ".";
        }
        if ((colon = key.indexOf(58)) != -1) {
            key = key.substring(colon + 1);
        }
        text = (String)text + key;
        if (subKey != null) {
            text = (String)text + "." + subKey;
        }
        return text;
    }

    protected void addOptionsForComponents(OptionsList list, List<SettingsComponentType<?>> componentTypes) {
        for (SettingsComponentType<?> componentType : componentTypes) {
            ModernBetaRegistries.SETTINGS_COMPONENT_TYPE.getResourceKey(componentType).ifPresent(componentTypeKey -> {
                ResourceLocation componentTypeId = componentTypeKey.location();
                GraphicalConfigBuilder configBuilder = (GraphicalConfigBuilder)ModernBetaClientRegistries.SETTINGS_COMPONENT_TYPE_GUI.getValue(componentTypeId);
                if (configBuilder == null) {
                    list.addBig(this.headerOption((Component)Component.translatable((String)"createWorld.customize.modern_beta.settings.invalidComponentType", (Object[])new Object[]{componentTypeId.toString()}).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC})));
                    return;
                }
                if (!((CompoundTag)this.settings).contains(componentTypeId.toString())) {
                    ((CompoundTag)this.settings).put(componentTypeId.toString(), (Tag)VersionCompat.getOrThrow(componentType.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, componentType.defaultValue())));
                }
                this.currentComponentType = componentTypeId;
                list.addBig(this.headerOption((Component)Component.translatable((String)("createWorld.customize.modern_beta.settings." + this.getCurrentComponentTypeAsString()))));
                configBuilder.apply(this, list);
                this.currentComponentType = null;
            });
        }
    }
}

