/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen.config;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import mod.bluestaggo.modernerbeta.client.gui.optioncallbacks.BiomePickerCallbacks;
import mod.bluestaggo.modernerbeta.client.gui.optioncallbacks.FloatSliderCallbacks;
import mod.bluestaggo.modernerbeta.client.gui.optioncallbacks.IntegerFieldCallbacks;
import mod.bluestaggo.modernerbeta.client.gui.optioncallbacks.TextFieldCallbacks;
import mod.bluestaggo.modernerbeta.client.gui.optioncallbacks.ValidatingIntMultipleSliderCallbacks;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.ModernBetaGraphicalListSettingsScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.ModernBetaGraphicalMapSettingsScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.ModernBetaGraphicalSettingsScreen;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.function.FloatSupplier;
import mod.bluestaggo.modernerbeta.world.biome.HeightConfig;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Tuple;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ModernBetaGraphicalCompoundSettingsScreen
extends ModernBetaGraphicalSettingsScreen<CompoundTag> {
    public ModernBetaGraphicalCompoundSettingsScreen(String title, Screen parent, WorldCreationContext generatorOptionsHolder, String type, CompoundTag settings, Consumer<CompoundTag> onDone) {
        super(title, parent, generatorOptionsHolder, type, settings, onDone);
    }

    protected Tuple<CompoundTag, String> resolveSettings(String key) {
        String[] subKeys = key.split("\\.");
        Tuple defaultPair = new Tuple((Object)((CompoundTag)this.settings), (Object)key);
        if (subKeys.length <= 1) {
            return defaultPair;
        }
        Tag element = this.settings;
        for (int i = 0; i < subKeys.length - 1; ++i) {
            if (element instanceof ListTag) {
                ListTag list = (ListTag)element;
                try {
                    element = (Tag)list.get(Integer.parseInt(subKeys[i]));
                    continue;
                }
                catch (NumberFormatException ignored) {
                    return defaultPair;
                }
            }
            if (element instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)element;
                element = compound.get(subKeys[i]);
                continue;
            }
            return defaultPair;
        }
        if (element instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)element;
            return new Tuple((Object)compound, (Object)subKeys[subKeys.length - 1]);
        }
        return defaultPair;
    }

    public OptionInstance<ResourceLocation> primarySelectionOption(String key, ResourceLocation ... options) {
        Tuple<CompoundTag, String> resolvedSettings = this.resolveSettings(key);
        CompoundTag settings = (CompoundTag)resolvedSettings.getA();
        String subKey = (String)resolvedSettings.getB();
        String textKey = this.getTextKey(key);
        Supplier<String> stringSupplier = () -> (String)VersionCompat.unwrap(settings.getString(subKey));
        return new OptionInstance(textKey, ModernBetaGraphicalCompoundSettingsScreen.getTooltip(textKey), (optionText, value) -> Component.translatable((String)(textKey + "." + String.valueOf(value))), (OptionInstance.ValueSet)new OptionInstance.LazyEnum(() -> Arrays.stream(options).toList(), value -> Arrays.stream(options).filter(arg_0 -> ((ResourceLocation)value).equals(arg_0)).findFirst(), ResourceLocation.CODEC), (Object)VersionCompat.id(stringSupplier.get()), value -> {
            settings.putString(subKey, value.toString());
            this.rebuildWidgets();
        });
    }

    public OptionInstance<String> selectionOption(String key, Supplier<StringRepresentable[]> options) {
        return this.selectionOption(key, (String[])Arrays.stream(options.get()).map(StringRepresentable::getSerializedName).toArray(String[]::new));
    }

    public OptionInstance<String> selectionOption(String key, String ... options) {
        Tuple<CompoundTag, String> resolvedSettings = this.resolveSettings(key);
        CompoundTag settings = (CompoundTag)resolvedSettings.getA();
        String subKey = (String)resolvedSettings.getB();
        String textKey = this.getTextKey(key);
        Supplier<String> stringSupplier = () -> (String)VersionCompat.unwrap(settings.getString(subKey));
        return new OptionInstance(textKey, ModernBetaGraphicalCompoundSettingsScreen.getTooltip(textKey), (optionText, value) -> Component.translatable((String)(textKey + "." + value)), (OptionInstance.ValueSet)new OptionInstance.LazyEnum(() -> Arrays.stream(options).toList(), value -> Arrays.stream(options).filter(value::equals).findFirst(), (Codec)Codec.STRING), (Object)stringSupplier.get(), value -> settings.putString(subKey, value));
    }

    public OptionInstance<Boolean> booleanOption(String key) {
        Tuple<CompoundTag, String> resolvedSettings = this.resolveSettings(key);
        CompoundTag settings = (CompoundTag)resolvedSettings.getA();
        String subKey = (String)resolvedSettings.getB();
        BooleanSupplier booleanSupplier = () -> VersionCompat.unwrapOrElse(settings.getBoolean(subKey), Boolean.valueOf(false));
        return OptionInstance.createBoolean((String)this.getTextKey(key), (boolean)booleanSupplier.getAsBoolean(), value -> settings.putBoolean(subKey, value.booleanValue()));
    }

    public OptionInstance<Integer> intRangeOption(String key, int min, int max) {
        String textKey = this.getTextKey(key);
        return this.intRangeOption(key, (OptionInstance.IntRangeBase)new OptionInstance.IntRange(min, max), (OptionInstance.CaptionBasedToString<Integer>)((OptionInstance.CaptionBasedToString)(optionText, value) -> Options.genericValueLabel((Component)Component.translatable((String)textKey), (int)value)));
    }

    public OptionInstance<Integer> intRangeOption(String key, int min, int max, int multiple) {
        String textKey = this.getTextKey(key);
        return this.intRangeOption(key, new ValidatingIntMultipleSliderCallbacks(min, max, multiple), (OptionInstance.CaptionBasedToString<Integer>)((OptionInstance.CaptionBasedToString)(optionText, value) -> Options.genericValueLabel((Component)Component.translatable((String)textKey), (int)value)));
    }

    public OptionInstance<Integer> intRangeOption(String key, OptionInstance.IntRangeBase intSliderCallbacks) {
        String textKey = this.getTextKey(key);
        return this.intRangeOption(key, intSliderCallbacks, (OptionInstance.CaptionBasedToString<Integer>)((OptionInstance.CaptionBasedToString)(optionText, value) -> Options.genericValueLabel((Component)Component.translatable((String)textKey), (int)value)));
    }

    public OptionInstance<Integer> intRangeOption(String key, OptionInstance.IntRangeBase intSliderCallbacks, OptionInstance.CaptionBasedToString<Integer> valueTextGetter) {
        Tuple<CompoundTag, String> resolvedSettings = this.resolveSettings(key);
        CompoundTag settings = (CompoundTag)resolvedSettings.getA();
        String subKey = (String)resolvedSettings.getB();
        IntSupplier intSupplier = () -> VersionCompat.unwrapOrElse(settings.getInt(subKey), Integer.valueOf(0));
        return new OptionInstance(this.getTextKey(key), ModernBetaGraphicalCompoundSettingsScreen.getTooltip(this.getTextKey(key)), valueTextGetter, (OptionInstance.ValueSet)intSliderCallbacks, (Object)intSupplier.getAsInt(), value -> settings.putInt(subKey, value.intValue()));
    }

    public OptionInstance<Integer> intFieldOption(String key) {
        return this.intFieldOption(key, "");
    }

    public OptionInstance<Integer> intFieldOption(String key, String prefix) {
        return this.intFieldOption(key, prefix, Integer::toString, Integer::parseInt);
    }

    public OptionInstance<Integer> rgbFieldOption(String key, String prefix) {
        return this.intFieldOption(key, prefix, i -> String.format("%06X", i), s -> Integer.parseInt(s, 16));
    }

    public OptionInstance<Integer> intFieldOption(String key, String prefix, IntFunction<String> serializer, ToIntFunction<String> deserializer) {
        if (prefix == null) {
            prefix = "";
        } else if (!((String)prefix).isEmpty()) {
            prefix = (String)prefix + ": ";
        }
        Tuple<CompoundTag, String> resolvedSettings = this.resolveSettings(key);
        CompoundTag settings = (CompoundTag)resolvedSettings.getA();
        String subKey = (String)resolvedSettings.getB();
        IntSupplier intSupplier = () -> VersionCompat.unwrapOrElse(settings.getInt(subKey), Integer.valueOf(0));
        return new OptionInstance(this.getTextKey(key), ModernBetaGraphicalCompoundSettingsScreen.getTooltip(this.getTextKey(key)), (optionText, value) -> Component.nullToEmpty((String)Integer.toString(intSupplier.getAsInt())), (OptionInstance.ValueSet)new IntegerFieldCallbacks((String)prefix, serializer, deserializer), (Object)intSupplier.getAsInt(), value -> settings.putInt(subKey, value.intValue()));
    }

    public OptionInstance<Integer> intFieldOptionFromString(String key, String prefix) {
        return this.intFieldOptionFromString(key, prefix, Integer::toString, Integer::parseInt);
    }

    public OptionInstance<Integer> intFieldOptionFromString(String key, String prefix, IntFunction<String> serializer, ToIntFunction<String> deserializer) {
        if (prefix == null) {
            prefix = "";
        } else if (!((String)prefix).isEmpty()) {
            prefix = (String)prefix + ": ";
        }
        Tuple<CompoundTag, String> resolvedSettings = this.resolveSettings(key);
        CompoundTag settings = (CompoundTag)resolvedSettings.getA();
        String subKey = (String)resolvedSettings.getB();
        Supplier<String> stringSupplier = () -> VersionCompat.unwrapOrElse(settings.getString(subKey), "0");
        int defaultValue = 0;
        try {
            defaultValue = Integer.parseInt(stringSupplier.get());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new OptionInstance(this.getTextKey(key), ModernBetaGraphicalCompoundSettingsScreen.getTooltip(this.getTextKey(key)), (optionText, value) -> Component.nullToEmpty((String)((String)stringSupplier.get())), (OptionInstance.ValueSet)new IntegerFieldCallbacks((String)prefix, serializer, deserializer), (Object)defaultValue, value -> settings.putString(subKey, Integer.toString(value)));
    }

    public OptionInstance<Float> floatRangeOption(String key, float min, float max) {
        Tuple<CompoundTag, String> resolvedSettings = this.resolveSettings(key);
        CompoundTag settings = (CompoundTag)resolvedSettings.getA();
        String subKey = (String)resolvedSettings.getB();
        String textKey = this.getTextKey(key);
        FloatSupplier floatSupplier = () -> VersionCompat.unwrapOrElse(settings.getFloat(subKey), Float.valueOf(0.0f)).floatValue();
        return new OptionInstance(textKey, ModernBetaGraphicalCompoundSettingsScreen.getTooltip(textKey), (optionText, value) -> Options.genericValueLabel((Component)Component.translatable((String)textKey), (Component)Component.literal((String)"%.3f".formatted(value))), (OptionInstance.ValueSet)new FloatSliderCallbacks(min, max), (Object)Float.valueOf(floatSupplier.getAsFloat()), value -> settings.putFloat(subKey, value.floatValue()));
    }

    public OptionInstance<String> stringOption(String key) {
        return this.stringOption(key, TextFieldCallbacks.NO_VALIDATION);
    }

    public OptionInstance<String> stringOption(String key, TextFieldCallbacks callbacks) {
        Tuple<CompoundTag, String> resolvedSettings = this.resolveSettings(key);
        CompoundTag settings = (CompoundTag)resolvedSettings.getA();
        String subKey = (String)resolvedSettings.getB();
        Supplier<String> stringSupplier = () -> (String)VersionCompat.unwrap(settings.getString(subKey));
        return new OptionInstance(this.getTextKey(key), ModernBetaGraphicalCompoundSettingsScreen.getTooltip(this.getTextKey(key)), (optionText, value) -> Component.nullToEmpty((String)((String)stringSupplier.get())), (OptionInstance.ValueSet)callbacks, (Object)stringSupplier.get(), value -> settings.putString(subKey, value));
    }

    public OptionInstance<String> blockOption(String key) {
        return this.stringOption(key, new TextFieldCallbacks(value -> BuiltInRegistries.BLOCK.containsKey(ResourceLocation.tryParse((String)value)), value -> ResourceLocation.read((String)value).error().isEmpty()));
    }

    public OptionInstance<String> biomeOption(String key, boolean allowNone) {
        Tuple<CompoundTag, String> resolvedSettings = this.resolveSettings(key);
        CompoundTag settings = (CompoundTag)resolvedSettings.getA();
        String subKey = (String)resolvedSettings.getB();
        Supplier<String> stringSupplier = () -> (String)VersionCompat.unwrap(settings.getString(subKey));
        return new OptionInstance(this.getTextKey(key), ModernBetaGraphicalCompoundSettingsScreen.getTooltip(this.getTextKey(key)), (optionText, value) -> Component.nullToEmpty((String)((String)stringSupplier.get())), (OptionInstance.ValueSet)new BiomePickerCallbacks(arg_0 -> ((Minecraft)this.minecraft).setScreen(arg_0), (Screen)this, this.generatorOptionsHolder, allowNone), (Object)stringSupplier.get(), value -> {
            settings.putString(subKey, value);
            this.rebuildWidgets();
        });
    }

    public OptionInstance<?> extendedBiomeIdOption(String key) {
        Tuple<CompoundTag, String> resolvedSettings = this.resolveSettings(key);
        CompoundTag settings = (CompoundTag)resolvedSettings.getA();
        String subKey = (String)resolvedSettings.getB();
        Supplier<String> stringSupplier = () -> (String)VersionCompat.unwrap(settings.getString(subKey));
        return new OptionInstance("", OptionInstance.noTooltip(), (optionText, value) -> Component.nullToEmpty((String)((String)stringSupplier.get())), (OptionInstance.ValueSet)new TextFieldCallbacks(string -> ExtendedBiomeId.validate(string).error().isEmpty()), (Object)ExtendedBiomeId.of(stringSupplier.get()).toString(), value -> settings.putString(subKey, value));
    }

    public List<OptionInstance<?>> heightConfigOption(String key) {
        Tuple<CompoundTag, String> resolvedSettings = this.resolveSettings(key);
        CompoundTag settings = (CompoundTag)resolvedSettings.getA();
        String subKey = (String)resolvedSettings.getB();
        Supplier<String> stringSupplier = () -> (String)VersionCompat.unwrap(settings.getString(subKey));
        Supplier<String> defaultedStringSupplier = () -> VersionCompat.unwrapOrElse(settings.getString(subKey), "");
        return List.of(new OptionInstance("createWorld.customize.modern_beta.settings.heightConfig.depth", ModernBetaGraphicalCompoundSettingsScreen.getTooltip("createWorld.customize.modern_beta.settings.heightConfig.depth.desc"), (optionText, value) -> Options.genericValueLabel((Component)Component.translatable((String)"createWorld.customize.modern_beta.settings.heightConfig.depth"), (Component)Component.literal((String)String.format("%.2f", Float.valueOf(HeightConfig.parse((String)stringSupplier.get(), HeightConfig.DEFAULT).depth())))), (OptionInstance.ValueSet)new FloatSliderCallbacks(-2.0f, 2.0f), (Object)Float.valueOf(HeightConfig.parse(stringSupplier.get(), HeightConfig.DEFAULT).depth()), value -> {
            String replacedString = (String)defaultedStringSupplier.get();
            float replacedScale = HeightConfig.parse(replacedString, HeightConfig.DEFAULT).scale();
            settings.putString(subKey, HeightConfig.makeString((float)Mth.floor((float)(value.floatValue() * 100.0f)) / 100.0f, replacedScale));
        }), new OptionInstance("createWorld.customize.modern_beta.settings.heightConfig.scale", ModernBetaGraphicalCompoundSettingsScreen.getTooltip("createWorld.customize.modern_beta.settings.heightConfig.scale.desc"), (optionText, value) -> Options.genericValueLabel((Component)Component.translatable((String)"createWorld.customize.modern_beta.settings.heightConfig.scale"), (Component)Component.literal((String)String.format("%.2f", Float.valueOf(HeightConfig.parse((String)stringSupplier.get(), HeightConfig.DEFAULT).scale())))), (OptionInstance.ValueSet)new FloatSliderCallbacks(0.0f, 5.0f), (Object)Float.valueOf(HeightConfig.parse(stringSupplier.get(), HeightConfig.DEFAULT).scale()), value -> {
            String replacedString = (String)defaultedStringSupplier.get();
            float replacedDepth = HeightConfig.parse(replacedString, HeightConfig.DEFAULT).depth();
            settings.putString(subKey, HeightConfig.makeString(replacedDepth, (float)Mth.floor((float)(value.floatValue() * 100.0f)) / 100.0f));
        }));
    }

    public OptionInstance<Void> listEditButton(Component text, String key, int type, ModernBetaGraphicalListSettingsScreen.Constructor listSettingsScreenConstructor) {
        Tuple<CompoundTag, String> resolvedSettings = this.resolveSettings(key);
        CompoundTag settings = (CompoundTag)resolvedSettings.getA();
        String subKey = (String)resolvedSettings.getB();
        Supplier<ListTag> listSupplier = () -> (ListTag)VersionCompat.unwrap(settings.getList(subKey));
        return this.customButton((Component)Component.translatable((String)"createWorld.customize.modern_beta.settings.list.button", (Object[])new Object[]{text.getString()}), () -> this.minecraft.setScreen((Screen)listSettingsScreenConstructor.create(Component.translatable((String)"createWorld.customize.modern_beta.settings.list.title", (Object[])new Object[]{text.getString()}).getString(), (Screen)this, this.generatorOptionsHolder, ((ListTag)listSupplier.get()).copy(), list -> settings.put(subKey, (Tag)list))));
    }

    public OptionInstance<Void> mapEditButton(Component text, String key, ModernBetaGraphicalMapSettingsScreen.Constructor mapSettingsScreenConstructor) {
        Tuple<CompoundTag, String> resolvedSettings = this.resolveSettings(key);
        CompoundTag settings = (CompoundTag)resolvedSettings.getA();
        String subKey = (String)resolvedSettings.getB();
        Supplier<CompoundTag> compoundSupplier = () -> (CompoundTag)VersionCompat.unwrap(settings.getCompound(subKey));
        return this.customButton((Component)Component.translatable((String)"createWorld.customize.modern_beta.settings.list.button", (Object[])new Object[]{text.getString()}), () -> this.minecraft.setScreen((Screen)mapSettingsScreenConstructor.create(Component.translatable((String)"createWorld.customize.modern_beta.settings.list.titleMap", (Object[])new Object[]{text.getString()}).getString(), (Screen)this, this.generatorOptionsHolder, (CompoundTag)compoundSupplier.get(), compound -> settings.put(subKey, (Tag)compound))));
    }
}

