/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.bluestaggo.modernerbeta.client.gui.optioncallbacks.BiomePickerCallbacks;
import mod.bluestaggo.modernerbeta.client.gui.optioncallbacks.FloatSliderCallbacks;
import mod.bluestaggo.modernerbeta.client.gui.optioncallbacks.TextFieldCallbacks;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.ModernBetaGraphicalSettingsScreen;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ModernBetaGraphicalListSettingsScreen
extends ModernBetaGraphicalSettingsScreen<ListTag> {
    public ModernBetaGraphicalListSettingsScreen(String title, Screen parent, WorldCreationContext generatorOptionsHolder, ListTag settings, Consumer<ListTag> onDone) {
        super(title, parent, generatorOptionsHolder, "list", settings, onDone);
    }

    protected abstract List<OptionInstance<?>> getOptions(int var1);

    protected abstract Tag getDefaultElement();

    @Override
    protected void addOptions(OptionsList list) {
        for (int i = 0; i < ((ListTag)this.settings).size(); ++i) {
            int finalI = i;
            ArrayList options = new ArrayList(this.getOptions(i));
            if (options.isEmpty()) continue;
            OptionInstance<Void> removeButton = this.customButton((Component)this.getText("remove"), () -> {
                ((ListTag)this.settings).remove(finalI);
                this.rebuildWidgets();
            });
            options.add(removeButton);
            if (options.size() % 2 == 1) {
                options.add(null);
            }
            for (int j = 0; j < options.size(); j += 2) {
                OptionInstance left = (OptionInstance)options.get(j);
                OptionInstance right = (OptionInstance)options.get(j + 1);
                if (right != null) {
                    list.addSmall(new OptionInstance[]{left, right});
                    continue;
                }
                list.addBig(left);
            }
        }
        list.addBig(this.headerOption((Component)Component.empty()));
        list.addBig(this.customButton((Component)this.getText("add"), () -> {
            ((ListTag)this.settings).add((Object)this.getDefaultElement());
            this.rebuildWidgets();
        }));
    }

    protected OptionInstance<?> biomeOption(int i, boolean allowNone) {
        Supplier<String> stringSupplier = () -> (String)VersionCompat.unwrap(((ListTag)this.settings).getString(i));
        return new OptionInstance("", OptionInstance.noTooltip(), (optionText, value) -> Component.nullToEmpty((String)((String)stringSupplier.get())), (OptionInstance.ValueSet)new BiomePickerCallbacks(arg_0 -> ((Minecraft)this.minecraft).setScreen(arg_0), (Screen)this, this.generatorOptionsHolder, allowNone), (Object)stringSupplier.get(), value -> {
            ((ListTag)this.settings).remove(i);
            ((ListTag)this.settings).add(i, (Tag)StringTag.valueOf((String)value));
            this.rebuildWidgets();
        });
    }

    protected OptionInstance<?> biomeSubOption(int i, String subKey, boolean allowNone) {
        Supplier<CompoundTag> compoundSupplier = () -> (CompoundTag)VersionCompat.unwrap(((ListTag)this.settings).getCompound(i));
        Supplier<String> stringSupplier = () -> VersionCompat.unwrapOrElse(((CompoundTag)compoundSupplier.get()).getString(subKey), "");
        return new OptionInstance("", OptionInstance.noTooltip(), (optionText, value) -> Component.nullToEmpty((String)((String)stringSupplier.get())), (OptionInstance.ValueSet)new BiomePickerCallbacks(arg_0 -> ((Minecraft)this.minecraft).setScreen(arg_0), (Screen)this, this.generatorOptionsHolder, allowNone), (Object)stringSupplier.get(), value -> {
            ((CompoundTag)compoundSupplier.get()).put(subKey, (Tag)StringTag.valueOf((String)value));
            this.rebuildWidgets();
        });
    }

    protected OptionInstance<Float> floatRangeSubOption(int i, String subKey, float min, float max) {
        Supplier<CompoundTag> compoundSupplier = () -> (CompoundTag)VersionCompat.unwrap(((ListTag)this.settings).getCompound(i));
        return new OptionInstance(this.getTextKey(subKey), OptionInstance.noTooltip(), (optionText, value) -> Options.genericValueLabel((Component)this.getText(subKey), (Component)Component.literal((String)"%.3f".formatted(value))), (OptionInstance.ValueSet)new FloatSliderCallbacks(min, max), (Object)VersionCompat.unwrapOrElse(compoundSupplier.get().getFloat(subKey), Float.valueOf(0.0f)), value -> ((CompoundTag)compoundSupplier.get()).putFloat(subKey, value.floatValue()));
    }

    protected List<OptionInstance<?>> extendedBiomeIdOption(int i) {
        Supplier<String> stringSupplier = () -> VersionCompat.unwrapOrElse(((ListTag)this.settings).getString(i), "");
        return List.of(new OptionInstance("", OptionInstance.noTooltip(), (optionText, value) -> Component.nullToEmpty((String)((String)stringSupplier.get())), (OptionInstance.ValueSet)new TextFieldCallbacks(string -> ExtendedBiomeId.validate(string).error().isEmpty()), (Object)ExtendedBiomeId.of(stringSupplier.get()).toString(), value -> {
            ((ListTag)this.settings).add(i, (Tag)StringTag.valueOf((String)value));
            this.rebuildWidgets();
        }));
    }

    protected List<OptionInstance<?>> voronoiPointBiomeOption(int i) {
        ArrayList list = new ArrayList(List.of(this.headerOption((Component)Component.translatable((String)"createWorld.customize.modern_beta.settings.climate_mappings.biome")), this.biomeSubOption(i, "biome", false), this.headerOption((Component)Component.translatable((String)"createWorld.customize.modern_beta.settings.climate_mappings.oceanBiome")), this.biomeSubOption(i, "oceanBiome", false), this.headerOption((Component)Component.translatable((String)"createWorld.customize.modern_beta.settings.climate_mappings.deepOceanBiome")), this.biomeSubOption(i, "deepOceanBiome", false), this.floatRangeSubOption(i, "temp", 0.0f, 1.0f), this.floatRangeSubOption(i, "rain", 0.0f, 1.0f), this.floatRangeSubOption(i, "weird", 0.0f, 1.0f)));
        list.add(null);
        return list;
    }

    protected List<OptionInstance<?>> voronoiPointCaveBiomeOption(int i) {
        ArrayList list = new ArrayList(List.of(this.headerOption((Component)Component.translatable((String)"createWorld.customize.modern_beta.settings.climate_mappings.biome")), this.biomeSubOption(i, "biome", true), this.floatRangeSubOption(i, "temp", 0.0f, 1.0f), this.floatRangeSubOption(i, "rain", 0.0f, 1.0f), this.floatRangeSubOption(i, "depth", 0.0f, 1.0f)));
        list.add(null);
        return list;
    }

    @FunctionalInterface
    public static interface Constructor {
        public ModernBetaGraphicalListSettingsScreen create(String var1, Screen var2, WorldCreationContext var3, ListTag var4, Consumer<ListTag> var5);
    }
}

