/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen.config;

import java.util.Optional;
import java.util.function.Consumer;
import mod.bluestaggo.modernerbeta.ModernBetaBuiltInTypes;
import mod.bluestaggo.modernerbeta.api.world.provider.ProviderType;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.ModernBetaGraphicalComponentedSettingsScreen;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModernBetaGraphicalProviderSettingsScreen
extends ModernBetaGraphicalComponentedSettingsScreen {
    private final Registry<? extends ProviderType> providerRegistry;
    private final ResourceLocation[] providers;
    public final int worldMinY;
    public final int worldMaxY;

    public ModernBetaGraphicalProviderSettingsScreen(String title, Screen parent, WorldCreationContext generatorOptionsHolder, CompoundTag settings, Consumer<CompoundTag> onDone, Registry<? extends ProviderType> providerRegistry) {
        super(title, parent, generatorOptionsHolder, (String)null, settings, onDone);
        this.providerRegistry = providerRegistry;
        this.providers = (ResourceLocation[])providerRegistry.listElements().map(Holder::unwrapKey).flatMap(Optional::stream).map(ResourceKey::location).sorted().toArray(ResourceLocation[]::new);
        ChunkGenerator chunkGenerator = generatorOptionsHolder.selectedDimensions().get(LevelStem.OVERWORLD).map(LevelStem::generator).orElse(null);
        if (chunkGenerator != null) {
            this.worldMinY = chunkGenerator.getMinY();
            this.worldMaxY = this.worldMinY + chunkGenerator.getGenDepth();
        } else {
            this.worldMinY = -64;
            this.worldMaxY = 320;
        }
    }

    @Override
    protected void addOptions(OptionsList list) {
        String providerKey = ModernBetaBuiltInTypes.SettingsComponentType.PROVIDER.id.toString();
        ResourceLocation providerId = VersionCompat.id((String)VersionCompat.unwrap(((CompoundTag)this.settings).getString(providerKey)));
        list.addBig(this.primarySelectionOption(providerKey, this.providers));
        ProviderType providerType = (ProviderType)this.providerRegistry.getValue(providerId);
        if (providerType == null) {
            list.addBig(this.headerOption((Component)Component.translatable((String)"createWorld.customize.modern_beta.settings.invalidProvider")));
        } else {
            this.addOptionsForComponents(list, providerType.requiredSettingsComponents().get());
        }
    }
}

