/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.resource;

import java.io.IOException;
import java.util.function.Consumer;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import net.minecraft.client.resources.LegacyStuffWrapper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModernBetaColormapResource
implements ResourceManagerReloadListener {
    private final ResourceLocation id;
    private final Consumer<int[]> consumer;

    public ModernBetaColormapResource(String path, Consumer<int[]> consumer) {
        this.id = ModernerBeta.createId(path);
        this.consumer = consumer;
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        int[] map;
        try {
            map = LegacyStuffWrapper.getPixels((ResourceManager)resourceManager, (ResourceLocation)this.id);
        }
        catch (IOException exception) {
            throw new IllegalStateException("[Modern Beta] Failed to load colormap texture!", exception);
        }
        this.consumer.accept(map);
    }
}

