/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.mixin;

import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.imixin.ModernBetaWorld;
import mod.bluestaggo.modernerbeta.world.feature.BetaFreezeTopLayerFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Biome.class})
public abstract class MixinBiome {
    @Shadow
    @Final
    private Biome.ClimateSettings climateSettings;

    @Inject(method={"shouldFreeze(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void canSetIceWithModernBetaClimate(LevelReader world, BlockPos pos, boolean doWaterCheck, CallbackInfoReturnable<Boolean> cir) {
        if (!(world instanceof ModernBetaWorld)) {
            return;
        }
        ModernBetaWorld serverWorld = (ModernBetaWorld)world;
        ClimateSampler climateSampler = serverWorld.modernerBeta$getClimateSampler();
        if (climateSampler == null) {
            return;
        }
        cir.setReturnValue((Object)BetaFreezeTopLayerFeature.canSetIce(world, pos, doWaterCheck, climateSampler.sampleModifiedTemperature(pos, this.climateSettings.temperatureModifier()), climateSampler.getSnowThreshold(), climateSampler.getHeightType()));
    }

    @Inject(method={"shouldSnow(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void canSetSnowWithModernBetaClimate(LevelReader world, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (!(world instanceof ModernBetaWorld)) {
            return;
        }
        ModernBetaWorld serverWorld = (ModernBetaWorld)world;
        ClimateSampler climateSampler = serverWorld.modernerBeta$getClimateSampler();
        if (climateSampler == null) {
            return;
        }
        cir.setReturnValue((Object)BetaFreezeTopLayerFeature.canSetSnow(world, pos, climateSampler.sampleModifiedTemperature(pos, this.climateSettings.temperatureModifier()), climateSampler.getSnowThreshold(), climateSampler.getHeightType()));
    }
}

