/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.mixin;

import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.world.chunk.provider.ChunkProviderEarlyRelease;
import mod.bluestaggo.modernerbeta.world.chunk.provider.ChunkProviderMajorRelease;
import mod.bluestaggo.modernerbeta.world.feature.BetaFreezeTopLayerFeature;
import mod.bluestaggo.modernerbeta.world.feature.placed.ModernBetaMiscPlacedFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.SnowAndFreezeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SnowAndFreezeFeature.class})
public abstract class MixinFreezeTopLayerFeature {
    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectGenerate(FeaturePlaceContext<NoneFeatureConfiguration> context, CallbackInfoReturnable<Boolean> info) {
        ModernBetaBiomeSource modernBetaBiomeSource;
        boolean hasClimateSampler;
        ModernBetaChunkGenerator modernBetaChunkGenerator;
        WorldGenLevel world = context.level();
        BlockPos pos = context.origin();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        BiomeSource biomeSource = chunkGenerator.getBiomeSource();
        if (chunkGenerator instanceof ModernBetaChunkGenerator && ((modernBetaChunkGenerator = (ModernBetaChunkGenerator)chunkGenerator).getChunkProvider() instanceof ChunkProviderEarlyRelease || modernBetaChunkGenerator.getChunkProvider() instanceof ChunkProviderMajorRelease)) {
            BetaFreezeTopLayerFeature.setFreezeTopLayer(world, pos, biomeSource, modernBetaChunkGenerator.allowSurfaceRules());
            info.setReturnValue((Object)true);
            return;
        }
        boolean bl = hasClimateSampler = biomeSource instanceof ModernBetaBiomeSource && (modernBetaBiomeSource = (ModernBetaBiomeSource)biomeSource).getBiomeProvider() instanceof ClimateSampler;
        if (hasClimateSampler) {
            int x = pos.getX();
            int z = pos.getZ();
            int y = context.level().getHeight(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
            BlockPos topPos = new BlockPos(x, y, z);
            Holder topBiome = context.level().getBiome(topPos);
            Holder.Reference betaFreezeTopLayer = context.level().registryAccess().lookupOrThrow(Registries.PLACED_FEATURE).get(ModernBetaMiscPlacedFeatures.FREEZE_TOP_LAYER).orElse(null);
            boolean hasBetaFreezeTopLayer = ((Biome)topBiome.value()).getGenerationSettings().features().stream().anyMatch(list -> list.contains((Holder)betaFreezeTopLayer));
            if (hasBetaFreezeTopLayer) {
                BetaFreezeTopLayerFeature.setFreezeTopLayer(world, pos, biomeSource, false);
                info.setReturnValue((Object)true);
            }
        }
    }
}

