/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderFinite;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.world.chunk.provider.ChunkProviderIndev;
import mod.bluestaggo.modernerbeta.world.chunk.provider.indev.IndevTheme;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.storage.ServerLevelData;
import org.slf4j.event.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer {
    @Inject(method={"setInitialSpawn(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/storage/ServerLevelData;ZZ)V"}, at={@At(value="RETURN")})
    private static void injectSetupSpawn(ServerLevel world, ServerLevelData worldProperties, boolean bonusChest, boolean debugWorld, CallbackInfo ci) {
        ChunkGenerator chunkGenerator = world.getChunkSource().getGenerator();
        if (chunkGenerator instanceof ModernBetaChunkGenerator) {
            worldProperties.setSpawn(worldProperties.getSpawnPos(), -90.0f);
        }
    }

    @WrapOperation(method={"setInitialSpawn(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/storage/ServerLevelData;ZZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/PlayerRespawnLogic;getSpawnPosInChunk(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/ChunkPos;)Lnet/minecraft/core/BlockPos;")})
    private static BlockPos redirectSpawnLocating(ServerLevel world, ChunkPos chunkPos, Operation<BlockPos> original) {
        ChunkGenerator chunkGenerator = world.getChunkSource().getGenerator();
        if (chunkGenerator instanceof ModernBetaChunkGenerator) {
            ModernBetaChunkGenerator modernBetaChunkGenerator = (ModernBetaChunkGenerator)chunkGenerator;
            ChunkProvider chunkProvider = modernBetaChunkGenerator.getChunkProvider();
            ((GameRules.IntegerValue)world.getGameRules().getRule(GameRules.RULE_SPAWN_RADIUS)).set(0, world.getServer());
            BlockPos spawnPos = chunkProvider.getSpawnLocator().locateSpawn((LevelHeightAccessor)world).orElseGet(() -> (BlockPos)original.call(new Object[]{world, chunkPos}));
            if (spawnPos != null && ModernerBeta.DEV_ENV) {
                int x = spawnPos.getX();
                int y = spawnPos.getY();
                int z = spawnPos.getZ();
                ModernerBeta.log(Level.INFO, String.format("Spawning at %d/%d/%d", x, y, z));
            }
            if (spawnPos != null && chunkProvider instanceof ChunkProviderIndev) {
                ChunkProviderIndev chunkProviderIndev = (ChunkProviderIndev)chunkProvider;
                chunkProviderIndev.generateIndevHouse(world, spawnPos);
                MixinMinecraftServer.setIndevProperties(world, chunkProviderIndev.getLevelTheme());
            }
            if (chunkProvider instanceof ChunkProviderFinite) {
                ChunkProviderFinite.resetPhase();
            }
            return spawnPos;
        }
        return (BlockPos)original.call(new Object[]{world, chunkPos});
    }

    @Unique
    private static void setIndevProperties(ServerLevel world, IndevTheme theme) {
        switch (theme) {
            case HELL: {
                ((GameRules.BooleanValue)world.getGameRules().getRule(GameRules.RULE_DAYLIGHT)).set(false, null);
                ((GameRules.BooleanValue)world.getGameRules().getRule(GameRules.RULE_WEATHER_CYCLE)).set(false, null);
                world.setDayTime(18000L);
                break;
            }
            case PARADISE: {
                ((GameRules.BooleanValue)world.getGameRules().getRule(GameRules.RULE_DAYLIGHT)).set(false, null);
                ((GameRules.BooleanValue)world.getGameRules().getRule(GameRules.RULE_WEATHER_CYCLE)).set(false, null);
                world.setDayTime(6000L);
                break;
            }
            case WOODS: {
                ((GameRules.BooleanValue)world.getGameRules().getRule(GameRules.RULE_WEATHER_CYCLE)).set(false, null);
                world.setWeatherParameters(0, Integer.MAX_VALUE, true, false);
                break;
            }
        }
    }
}

