/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.mixin;

import java.util.Optional;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.provider.BiomeProviderType;
import mod.bluestaggo.modernerbeta.network.BiomeProviderInfoPayload;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public abstract class MixinPlayerManager {
    @Inject(method={"sendLevelInfo(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="HEAD")})
    private void sendBiomeProviderInfo(ServerPlayer player, ServerLevel world, CallbackInfo ci) {
        BiomeProviderInfoPayload payload;
        boolean isModernBeta;
        if (ModernerBeta.networkHelper == null) {
            throw new RuntimeException("Lousy porter did NOT make a network helper!");
        }
        ChunkGenerator chunkGenerator = world.getChunkSource().getGenerator();
        BiomeSource biomeSource = chunkGenerator.getBiomeSource();
        boolean bl = isModernBeta = chunkGenerator instanceof ModernBetaChunkGenerator || biomeSource instanceof ModernBetaBiomeSource;
        if (biomeSource instanceof ModernBetaBiomeSource) {
            ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)biomeSource;
            BiomeProvider provider = modernBetaBiomeSource.getBiomeProvider();
            ResourceLocation id = ((ResourceKey)ModernBetaRegistries.BIOME.entrySet().stream().filter(c -> ((BiomeProviderType)c.getValue()).providerClass() == provider.getClass()).findFirst().orElseThrow().getKey()).location();
            payload = new BiomeProviderInfoPayload(true, true, Optional.of(world.getSeed()), Optional.of(id), Optional.of(provider.getSettings().toCompound()));
        } else {
            payload = new BiomeProviderInfoPayload(isModernBeta, false, Optional.empty(), Optional.empty(), Optional.empty());
        }
        ModernerBeta.networkHelper.sendToPlayer(player, payload);
    }
}

