/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.mixin;

import mod.bluestaggo.modernerbeta.world.biome.injector.BiomeInjector;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Structure.class})
public abstract class MixinStructure {
    @Inject(method={"isValidBiome(Lnet/minecraft/world/level/levelgen/structure/Structure$GenerationStub;Lnet/minecraft/world/level/levelgen/structure/Structure$GenerationContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectIsBiomeValid(Structure.GenerationStub result, Structure.GenerationContext context, CallbackInfoReturnable<Boolean> info) {
        ModernBetaChunkGenerator chunkGenerator;
        BlockPos blockPos = result.position();
        ChunkGenerator chunkGenerator2 = context.chunkGenerator();
        if (chunkGenerator2 instanceof ModernBetaChunkGenerator && (chunkGenerator = (ModernBetaChunkGenerator)chunkGenerator2).getBiomeInjector() != null) {
            Holder<Biome> biome = chunkGenerator.getBiomeInjector().getBiomeAtBlock(context.heightAccessor(), blockPos.getX(), blockPos.getY(), blockPos.getZ(), context.randomState().sampler(), BiomeInjector.BiomeInjectionStep.ALL);
            boolean isBiomeValid = context.validBiome().test(biome);
            info.setReturnValue((Object)isBiomeValid);
        }
    }
}

