/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.Clime;
import mod.bluestaggo.modernerbeta.client.FogUtils;
import mod.bluestaggo.modernerbeta.client.color.BlockColorSampler;
import mod.bluestaggo.modernerbeta.imixin.ModernBetaWorld;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={FogRenderer.class})
public abstract class MixinBackgroundRenderer {
    @Unique
    private static final String GET_FOG_COLOR_METHOD = "getFogColor";
    @Unique
    private static Vec3 modernBeta_pos;
    @Unique
    private static int modernBeta_renderDistance;
    @Unique
    private static float modernBeta_fogWeight;
    @Unique
    private static boolean modernBeta_isModernBetaWorld;

    @WrapOperation(method={"computeFogColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)Lorg/joml/Vector4f;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getWaterFogColor()I")})
    private static int modifyWaterFogColor(Biome instance, Operation<Integer> original) {
        if (BlockColorSampler.INSTANCE.useWaterColor()) {
            int x = (int)modernBeta_pos.x();
            int z = (int)modernBeta_pos.z();
            Clime clime = BlockColorSampler.INSTANCE.getClimateSampler().sample(x, z);
            return BlockColorSampler.INSTANCE.colormapUnderwater.getColor(clime.temp(), clime.rain());
        }
        return (Integer)original.call(new Object[]{instance});
    }

    @Inject(method={"computeFogColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)Lorg/joml/Vector4f;"}, at={@At(value="HEAD")})
    private static void captureVars(Camera camera, float tickDelta, ClientLevel world, int renderDistance, float skyDarkness, CallbackInfoReturnable<Vector4f> cir) {
        modernBeta_pos = camera.getPosition();
        if (modernBeta_renderDistance != renderDistance) {
            modernBeta_renderDistance = renderDistance;
            modernBeta_fogWeight = FogUtils.calculateFogWeight(renderDistance);
        }
        modernBeta_isModernBetaWorld = ((ModernBetaWorld)world).modernerBeta$isModded();
    }

    @ModifyVariable(method={"computeFogColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)Lorg/joml/Vector4f;"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getSkyColor(Lnet/minecraft/world/phys/Vec3;F)I"), index=10)
    private static float modifyFogWeighting(float weight) {
        return modernBeta_isModernBetaWorld && ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_MISCELLANEOUS).oldFogColorWeighting() ? modernBeta_fogWeight : weight;
    }

    static {
        modernBeta_renderDistance = 16;
        modernBeta_fogWeight = FogUtils.calculateFogWeight(16);
        modernBeta_isModernBetaWorld = false;
    }
}

