/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.registry;

import mod.bluestaggo.modernerbeta.ModernBetaBuiltInTypes;
import mod.bluestaggo.modernerbeta.api.world.BlockSourceCreator;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.api.world.provider.BiomeProviderType;
import mod.bluestaggo.modernerbeta.api.world.provider.CaveBiomeProviderType;
import mod.bluestaggo.modernerbeta.api.world.provider.ChunkProviderType;
import mod.bluestaggo.modernerbeta.registry.IRegistryHelper;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistryKeys;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentType;
import mod.bluestaggo.modernerbeta.world.biome.HeightConfig;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.predicates.BiomePredicateType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class ModernBetaRegistries {
    private static IRegistryHelper registryHelper;
    public static Registry<SettingsComponentType<?>> SETTINGS_COMPONENT_TYPE;
    public static Registry<ChunkProviderType<?>> CHUNK;
    public static Registry<BiomeProviderType<?>> BIOME;
    public static Registry<CaveBiomeProviderType<?>> CAVE_BIOME;
    public static Registry<SurfaceConfig> SURFACE_CONFIG;
    public static Registry<HeightConfig> HEIGHT_CONFIG;
    public static Registry<BlockSourceCreator> BLOCKSOURCE;
    public static Registry<LayerType<?>> FRACTAL_LAYER;
    public static Registry<BiomePredicateType<?>> BIOME_PREDICATE;

    private static <T> Registry<T> register(ResourceKey<Registry<T>> key) {
        return registryHelper.createSimple(key).build();
    }

    private static <T> Registry<T> registerDefaulted(ResourceKey<Registry<T>> key, ResourceLocation defaultKey) {
        return registryHelper.createDefaulted(key, defaultKey).build();
    }

    public static void makeRegistries(IRegistryHelper helper) {
        registryHelper = helper;
        SETTINGS_COMPONENT_TYPE = ModernBetaRegistries.register(ModernBetaRegistryKeys.SETTINGS_COMPONENT_TYPE);
        CHUNK = ModernBetaRegistries.registerDefaulted(ModernBetaRegistryKeys.CHUNK, ModernBetaBuiltInTypes.Chunk.BETA.id);
        BIOME = ModernBetaRegistries.registerDefaulted(ModernBetaRegistryKeys.BIOME, ModernBetaBuiltInTypes.Biome.BETA.id);
        CAVE_BIOME = ModernBetaRegistries.registerDefaulted(ModernBetaRegistryKeys.CAVE_BIOME, ModernBetaBuiltInTypes.CaveBiome.NONE.id);
        SURFACE_CONFIG = ModernBetaRegistries.register(ModernBetaRegistryKeys.SURFACE_CONFIG);
        HEIGHT_CONFIG = ModernBetaRegistries.registerDefaulted(ModernBetaRegistryKeys.HEIGHT_CONFIG, ModernBetaBuiltInTypes.HeightConfig.HEIGHT_CONFIG_DEFAULT.id);
        BLOCKSOURCE = ModernBetaRegistries.register(ModernBetaRegistryKeys.BLOCKSOURCE);
        FRACTAL_LAYER = ModernBetaRegistries.register(ModernBetaRegistryKeys.FRACTAL_LAYER);
        BIOME_PREDICATE = ModernBetaRegistries.register(ModernBetaRegistryKeys.BIOME_PREDICATE);
    }
}

