/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class NbtCompoundBuilder {
    private final CompoundTag compound;

    public NbtCompoundBuilder() {
        this.compound = new CompoundTag();
    }

    public NbtCompoundBuilder(CompoundTag initial) {
        this.compound = initial.copy();
    }

    public NbtCompoundBuilder putIdentifier(String key, ResourceLocation value) {
        this.compound.putString(key, value.toString());
        return this;
    }

    public NbtCompoundBuilder putString(String key, String value) {
        this.compound.putString(key, value);
        return this;
    }

    public NbtCompoundBuilder putInt(String key, int value) {
        this.compound.putInt(key, value);
        return this;
    }

    public NbtCompoundBuilder putBoolean(String key, boolean value) {
        this.compound.putBoolean(key, value);
        return this;
    }

    public NbtCompoundBuilder putFloat(String key, float value) {
        this.compound.putFloat(key, value);
        return this;
    }

    public NbtCompoundBuilder putDouble(String key, double value) {
        this.compound.putDouble(key, value);
        return this;
    }

    public NbtCompoundBuilder putList(String key, ListTag list) {
        this.compound.put(key, (Tag)list);
        return this;
    }

    public NbtCompoundBuilder putCompound(String key, CompoundTag compound) {
        this.compound.put(key, (Tag)compound);
        return this;
    }

    public NbtCompoundBuilder putBuilder(NbtCompoundBuilder builder) {
        builder.compound.keySet().forEach(key -> this.compound.put(key, this.compound.get(key)));
        return this;
    }

    public CompoundTag build() {
        return this.compound;
    }
}

