/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public final class VersionCompat {
    public static final Block SHORT_GRASS = Blocks.SHORT_GRASS;
    public static final String BIOME_GET_PRECIPITATION_TARGET = "Lnet/minecraft/world/biome/Biome;getPrecipitation(Lnet/minecraft/util/math/BlockPos;I)Lnet/minecraft/world/biome/Biome$Precipitation;";

    public static <T> T accessPool(WeightedList<T> pool, RandomSource random) {
        return (T)pool.getRandomOrThrow(random);
    }

    public static <T> T getWeightedValue(Weighted<T> weighted) {
        return (T)weighted.value();
    }

    public static <T> void forEachValueInPool(WeightedList<T> pool, Consumer<T> consumer) {
        for (Weighted entry : pool.unwrap()) {
            consumer.accept(VersionCompat.getWeightedValue(entry));
        }
    }

    public static void addSpawnEntry(MobSpawnSettings.Builder spawnSettings, MobCategory spawnGroup, EntityType<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        spawnSettings.addSpawn(spawnGroup, weight, new MobSpawnSettings.SpawnerData(entityType, minGroupSize, maxGroupSize));
    }

    public static void setBlockState(ChunkAccess chunk, BlockPos pos, BlockState blockState) {
        chunk.setBlockState(pos, blockState);
    }

    public static void setBlockState(ChunkAccess chunk, BlockPos pos, BlockState blockState, int flags) {
        chunk.setBlockState(pos, blockState, flags);
    }

    public static int getTopYExclusive(LevelHeightAccessor heightLimitView) {
        return heightLimitView.getMaxY() + 1;
    }

    public static <T> T unwrap(T t) {
        return t;
    }

    public static <T> T unwrap(Optional<T> optional) {
        return optional.orElseThrow();
    }

    public static <T> T unwrapOrElse(T t, T orElse) {
        return t;
    }

    public static <T> T unwrapOrElse(Optional<T> optional, T orElse) {
        return optional.orElse(orElse);
    }

    public static <T> T getOrThrow(DataResult<T> result) {
        return (T)result.getOrThrow();
    }

    public static ResourceLocation id(String string) {
        return ResourceLocation.parse((String)string);
    }

    public static ResourceLocation vanillaId(String string) {
        return ResourceLocation.withDefaultNamespace((String)string);
    }

    public static <O> MapCodec<O> createMaybeMapCodec(Function<RecordCodecBuilder.Instance<O>, ? extends App<RecordCodecBuilder.Mu<O>, O>> builder) {
        return RecordCodecBuilder.mapCodec(builder);
    }
}

