/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiFunction;
import net.minecraft.world.level.ChunkPos;

public class ChunkCache<T> {
    public static final int DEFAULT_SIZE = 512;
    public static final boolean DEFAULT_EVICT = true;
    private final String name;
    private final int capacity;
    private final boolean evictOldChunks;
    private final BiFunction<Integer, Integer, T> chunkFunc;
    private final Long2ObjectLinkedOpenHashMap<T> chunkMap;
    private final StampedLock lock;

    public ChunkCache(String name, int capacity, boolean evictOldChunks, BiFunction<Integer, Integer, T> chunkFunc) {
        this.name = name;
        this.capacity = capacity;
        this.evictOldChunks = evictOldChunks;
        this.chunkFunc = chunkFunc;
        this.chunkMap = new Long2ObjectLinkedOpenHashMap(capacity);
        this.lock = new StampedLock();
    }

    public ChunkCache(String name, int capacity, BiFunction<Integer, Integer, T> chunkFunc) {
        this(name, capacity, true, chunkFunc);
    }

    public ChunkCache(String name, BiFunction<Integer, Integer, T> chunkFunc) {
        this(name, 512, true, chunkFunc);
    }

    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.chunkMap.clear();
            this.chunkMap.trim();
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int chunkX, int chunkZ) {
        Object chunk;
        long key = ChunkPos.asLong((int)chunkX, (int)chunkZ);
        long stamp = this.lock.readLock();
        try {
            while ((chunk = this.chunkMap.get(key)) == null) {
                long writeStamp = this.lock.tryConvertToWriteLock(stamp);
                if (writeStamp != 0L) {
                    stamp = writeStamp;
                    chunk = this.createChunk(key, chunkX, chunkZ);
                    break;
                }
                this.lock.unlockRead(stamp);
                stamp = this.lock.writeLock();
            }
        }
        finally {
            this.lock.unlock(stamp);
        }
        return (T)chunk;
    }

    private T createChunk(long key, int chunkX, int chunkZ) {
        if (this.evictOldChunks && this.chunkMap.size() >= this.capacity) {
            this.chunkMap.removeFirst();
        }
        T chunk = this.chunkFunc.apply(chunkX, chunkZ);
        this.chunkMap.put(key, chunk);
        return chunk;
    }
}

