/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import org.apache.commons.lang3.function.TriFunction;

public class WorldChunkCache<T> {
    public static final int DEFAULT_SIZE = 512;
    public static final boolean DEFAULT_EVICT = true;
    private final String name;
    private final int capacity;
    private final boolean evictOldChunks;
    private final TriFunction<LevelHeightAccessor, Integer, Integer, T> chunkFunc;
    private final Long2ObjectLinkedOpenHashMap<T> chunkMap;
    private final StampedLock lock;

    public WorldChunkCache(String name, int capacity, boolean evictOldChunks, TriFunction<LevelHeightAccessor, Integer, Integer, T> chunkFunc) {
        this.name = name;
        this.capacity = capacity;
        this.evictOldChunks = evictOldChunks;
        this.chunkFunc = chunkFunc;
        this.chunkMap = new Long2ObjectLinkedOpenHashMap(capacity);
        this.lock = new StampedLock();
    }

    public WorldChunkCache(String name, int capacity, TriFunction<LevelHeightAccessor, Integer, Integer, T> chunkFunc) {
        this(name, capacity, true, chunkFunc);
    }

    public WorldChunkCache(String name, TriFunction<LevelHeightAccessor, Integer, Integer, T> chunkFunc) {
        this(name, 512, true, chunkFunc);
    }

    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.chunkMap.clear();
            this.chunkMap.trim();
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(LevelHeightAccessor world, int chunkX, int chunkZ) {
        Object chunk;
        long key = ChunkPos.asLong((int)chunkX, (int)chunkZ);
        long stamp = this.lock.readLock();
        try {
            while ((chunk = this.chunkMap.get(key)) == null) {
                long writeStamp = this.lock.tryConvertToWriteLock(stamp);
                if (writeStamp != 0L) {
                    stamp = writeStamp;
                    chunk = this.createChunk(key, world, chunkX, chunkZ);
                    break;
                }
                this.lock.unlockRead(stamp);
                stamp = this.lock.writeLock();
            }
        }
        finally {
            this.lock.unlock(stamp);
        }
        return (T)chunk;
    }

    private T createChunk(long key, LevelHeightAccessor world, int chunkX, int chunkZ) {
        if (this.evictOldChunks && this.chunkMap.size() >= this.capacity) {
            this.chunkMap.removeFirst();
        }
        Object chunk = this.chunkFunc.apply((Object)world, (Object)chunkX, (Object)chunkZ);
        this.chunkMap.put(key, chunk);
        return (T)chunk;
    }
}

