/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util.noise;

import java.util.Random;
import mod.bluestaggo.modernerbeta.util.noise.PerlinNoise;
import net.minecraft.util.Mth;

public class PerlinOctaveNoise {
    private final PerlinNoise[] noises;
    private final int octaves;

    public PerlinOctaveNoise(Random random, int octaves, boolean useOffset) {
        this.noises = new PerlinNoise[octaves];
        this.octaves = octaves;
        for (int i = 0; i < octaves; ++i) {
            this.noises[i] = new PerlinNoise(random, useOffset);
        }
    }

    public double[] sampleRelease(double x, double y, double z, int sizeX, int sizeY, int sizeZ, double scaleX, double scaleY, double scaleZ) {
        double[] noise = new double[sizeX * sizeY * sizeZ];
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            double offX = x * frequency * scaleX;
            double offZ = z * frequency * scaleZ;
            long offXCoord = Mth.lfloor((double)offX);
            long offZCoord = Mth.lfloor((double)offZ);
            offX -= (double)offXCoord;
            offZ -= (double)offZCoord;
            offX += (double)(offXCoord %= 0x1000000L);
            offZ += (double)(offZCoord %= 0x1000000L);
            this.noises[i].sampleBeta(noise, offX /= frequency * scaleX, y, offZ /= frequency * scaleX, sizeX, sizeY, sizeZ, scaleX * frequency, scaleY * frequency, scaleZ * frequency, frequency);
            frequency /= 2.0;
        }
        return noise;
    }

    public double[] sampleBeta(double x, double y, double z, int sizeX, int sizeY, int sizeZ, double scaleX, double scaleY, double scaleZ) {
        double[] noise = new double[sizeX * sizeY * sizeZ];
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            this.noises[i].sampleBeta(noise, x, y, z, sizeX, sizeY, sizeZ, scaleX * frequency, scaleY * frequency, scaleZ * frequency, frequency);
            frequency /= 2.0;
        }
        return noise;
    }

    public double[] sampleAlpha(double x, double y, double z, int sizeX, int sizeY, int sizeZ, double scaleX, double scaleY, double scaleZ) {
        double[] noise = new double[sizeX * sizeY * sizeZ];
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            this.noises[i].sampleAlpha(noise, x, y, z, sizeX, sizeY, sizeZ, scaleX * frequency, scaleY * frequency, scaleZ * frequency, frequency);
            frequency /= 2.0;
        }
        return noise;
    }

    public final double sampleXY(double x, double y) {
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            total += this.noises[i].sample(x / frequency, y / frequency) * frequency;
            frequency *= 2.0;
        }
        return total;
    }

    public final double sample(double x, double y, double z) {
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            total += this.noises[i].sample(x / frequency, y / frequency, z / frequency) * frequency;
            frequency *= 2.0;
        }
        return total;
    }

    public final double sampleXZWrapped(double x, double z, double scaleX, double scaleZ) {
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            double offX = x * frequency * scaleX;
            double offZ = z * frequency * scaleZ;
            long offXCoord = Mth.lfloor((double)offX);
            long offZCoord = Mth.lfloor((double)offZ);
            offX -= (double)offXCoord;
            offZ -= (double)offZCoord;
            total += this.noises[i].sampleXZ(offX += (double)(offXCoord %= 0x1000000L), offZ += (double)(offZCoord %= 0x1000000L), frequency);
            frequency /= 2.0;
        }
        return total;
    }

    public final double sampleXZ(double x, double z, double scaleX, double scaleZ) {
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            total += this.noises[i].sampleXZ(x * scaleX * frequency, z * scaleZ * frequency, frequency);
            frequency /= 2.0;
        }
        return total;
    }

    public final double sampleXZ(double x, double z, double scaleX, double scaleZ, boolean wrapped) {
        return wrapped ? this.sampleXZWrapped(x, z, scaleX, scaleZ) : this.sampleXZ(x, z, scaleX, scaleZ);
    }

    public final double sampleWrapped(double x, double y, double z, double scaleX, double scaleY, double scaleZ) {
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            double offX = x * frequency * scaleX;
            double offZ = z * frequency * scaleZ;
            long offXCoord = Mth.lfloor((double)offX);
            long offZCoord = Mth.lfloor((double)offZ);
            offX -= (double)offXCoord;
            offZ -= (double)offZCoord;
            total += this.noises[i].sampleXYZ(offX += (double)(offXCoord %= 0x1000000L), y * scaleY * frequency, offZ += (double)(offZCoord %= 0x1000000L), scaleY * frequency, y * scaleY * frequency) / frequency;
            frequency /= 2.0;
        }
        return total;
    }

    public final double sample(double x, double y, double z, double scaleX, double scaleY, double scaleZ) {
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            total += this.noises[i].sampleXYZ(x * scaleX * frequency, y * scaleY * frequency, z * scaleZ * frequency, scaleY * frequency, y * scaleY * frequency) / frequency;
            frequency /= 2.0;
        }
        return total;
    }

    public final double sample(double x, double y, double z, double scaleX, double scaleY, double scaleZ, boolean wrapped) {
        return wrapped ? this.sampleWrapped(x, y, z, scaleX, scaleY, scaleZ) : this.sample(x, y, z, scaleX, scaleY, scaleZ);
    }
}

