/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util.random;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicInteger;
import mod.bluestaggo.modernerbeta.util.random.mersenne.MersenneTwister;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;

public class BedrockCheckedRandom
extends LegacyRandomSource {
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final double TWO_POW_M32 = 2.3283064365386963E-10;
    private final AtomicInteger seed = new AtomicInteger();
    private final MersenneTwister mt;
    private boolean haveNextNextGaussian;
    private float nextNextGaussian;
    private final boolean valid;

    public BedrockCheckedRandom(long seed) {
        super(0L);
        this.mt = new MersenneTwister((int)seed);
        this.valid = true;
        this.setSeed(seed);
    }

    public int getSeed() {
        return this.seed.get();
    }

    public RandomSource fork() {
        return new BedrockCheckedRandom(this.nextInt());
    }

    public PositionalRandomFactory forkPositional() {
        return new Splitter(this.nextInt());
    }

    public void setSeed(long seed) {
        if (this.valid) {
            this.setSeed((int)seed);
        }
    }

    private void setSeed(int seed) {
        if (!this.seed.compareAndSet(this.seed.get(), seed)) {
            throw ThreadingDetector.makeThreadingException((String)"BedrockCheckedRandom", null);
        }
        this.haveNextNextGaussian = false;
        this.nextNextGaussian = 0.0f;
        this.mt.setSeed(seed);
    }

    public int nextInt() {
        return this.mt.genRandInt32() >>> 1;
    }

    public int nextInt(int bound) {
        if (bound > 0) {
            return (int)(Integer.toUnsignedLong(this.mt.genRandInt32()) % (long)bound);
        }
        return 0;
    }

    public boolean nextBoolean() {
        return (this.mt.genRandInt32() & Integer.MIN_VALUE) != 0;
    }

    public float nextFloat() {
        return (float)this.genRandReal2();
    }

    public double nextDouble() {
        return this.genRandReal2();
    }

    public double nextGaussian() {
        float v2;
        float v1;
        float s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = this.nextFloat() * 2.0f - 1.0f) * v1 + (v2 = this.nextFloat() * 2.0f - 1.0f) * v2) == 0.0f || s > 1.0f) {
        }
        float multiplier = (float)Math.sqrt(-2.0f * (float)Math.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public int next(int bits) {
        return this.mt.genRandInt32() >>> 32 - bits;
    }

    private double genRandReal2() {
        return (double)Integer.toUnsignedLong(this.mt.genRandInt32()) * 2.3283064365386963E-10;
    }

    public static class Splitter
    implements PositionalRandomFactory {
        private final int seed;

        public Splitter(int seed) {
            this.seed = seed;
        }

        public RandomSource at(int x, int y, int z) {
            long posHash = Mth.getSeed((int)x, (int)y, (int)z);
            long seed = posHash ^ (long)this.seed;
            return new BedrockCheckedRandom((int)seed);
        }

        public RandomSource fromHashOf(String seed) {
            int i = seed.hashCode();
            return new BedrockCheckedRandom(i ^ this.seed);
        }

        public RandomSource fromSeed(long seed) {
            return new BedrockCheckedRandom((int)seed);
        }

        @VisibleForTesting
        public void parityConfigString(StringBuilder info) {
            info.append("BedrockCheckedRandom.Splitter{").append(this.seed).append("}");
        }
    }
}

