/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world;

import mod.bluestaggo.modernerbeta.api.world.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.imixin.ModernBetaWorld;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;

public class ModernBetaWorldInitializer {
    public static void initStarting(MinecraftServer server) {
        Registry registryDimensionOptions = server.registries().compositeAccess().lookupOrThrow(Registries.LEVEL_STEM);
        long seed = server.getWorldData().worldGenOptions().seed();
        registryDimensionOptions.entrySet().forEach(entry -> {
            LevelStem dimensionOptions = (LevelStem)entry.getValue();
            ChunkGenerator chunkGenerator = dimensionOptions.generator();
            BiomeSource biomeSource = chunkGenerator.getBiomeSource();
            if (chunkGenerator instanceof ModernBetaChunkGenerator) {
                ModernBetaChunkGenerator modernBetaChunkGenerator = (ModernBetaChunkGenerator)chunkGenerator;
                modernBetaChunkGenerator.initProvider(seed);
            }
            if (biomeSource instanceof ModernBetaBiomeSource) {
                ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)biomeSource;
                modernBetaBiomeSource.initProvider(seed);
            }
        });
    }

    public static void initStarted(MinecraftServer server) {
        for (ServerLevel world : server.getAllLevels()) {
            ModernBetaChunkGenerator chunkGenerator;
            ModernBetaWorld modernBetaWorld = (ModernBetaWorld)world;
            ChunkGenerator chunkGenerator2 = world.getChunkSource().getGenerator();
            if (!(chunkGenerator2 instanceof ModernBetaChunkGenerator) || !((chunkGenerator2 = (chunkGenerator = (ModernBetaChunkGenerator)chunkGenerator2).getBiomeSource()) instanceof ModernBetaBiomeSource)) continue;
            ModernBetaBiomeSource biomeSource = (ModernBetaBiomeSource)chunkGenerator2;
            modernBetaWorld.modernerBeta$setModded(true);
            BiomeProvider biomeProvider = biomeSource.getBiomeProvider();
            if (biomeProvider instanceof ClimateSampler) {
                ClimateSampler climateSampler = (ClimateSampler)((Object)biomeProvider);
                modernBetaWorld.modernerBeta$setClimateSampler(climateSampler);
            }
            modernBetaWorld.modernerBeta$setTemperatureHeightScaling(biomeSource.getBiomeProvider().getTemperatureHeightScaling());
        }
    }
}

