/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider;

import java.util.Optional;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSamplerSky;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.Clime;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.TemperatureHeightScaling;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.ClimateDistribution;
import mod.bluestaggo.modernerbeta.world.biome.provider.BiomeProviderFractal;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.intlayers.IntClimateSampleLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.intlayers.IntLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.intlayers.IntZoomLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import net.minecraft.core.HolderGetter;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;

public class BiomeProviderBetaFractal
extends BiomeProviderFractal
implements ClimateSampler,
ClimateSamplerSky {
    private final IntLayer temperatureLayer;
    private final IntLayer downfallLayer;
    private final ClimateDistribution distribution;

    public BiomeProviderBetaFractal(ModernBetaSettings settings, HolderGetter<Biome> biomeRegistry, long seed) {
        super(settings, biomeRegistry, seed);
        Optional<Layer> layer;
        int i = 0;
        IntClimateSampleLayer temperatureLayer = null;
        IntClimateSampleLayer downfallLayer = null;
        while (!(layer = this.configuredLayers.getOutput(ModernerBeta.createId("climate_" + i))).isEmpty()) {
            if (i == 0) {
                temperatureLayer = new IntClimateSampleLayer(layer.get(), false);
                downfallLayer = new IntClimateSampleLayer(layer.get(), true);
            } else {
                temperatureLayer = new IntClimateSampleLayer(layer.get(), false, new IntZoomLayer(999 + i, temperatureLayer), i + 1);
                downfallLayer = new IntClimateSampleLayer(layer.get(), true, new IntZoomLayer(999 + i, downfallLayer), i * 2 + 1);
            }
            ++i;
        }
        if (temperatureLayer == null) {
            throw new IllegalArgumentException("No climate sample points provided!");
        }
        this.temperatureLayer = new IntZoomLayer(1001L, new IntZoomLayer(1000L, temperatureLayer));
        this.downfallLayer = new IntZoomLayer(1001L, new IntZoomLayer(1000L, downfallLayer));
        this.temperatureLayer.init(seed);
        this.downfallLayer.init(seed);
        this.distribution = settings.getOrDefault(SettingsComponentTypes.CLIMATE_DISTRIBUTION);
    }

    @Override
    public Clime sample(int x, int z) {
        int temperature = this.temperatureLayer.sample((HolderGetter<Biome>)this.biomeRegistry, x, z);
        int downfall = this.downfallLayer.sample((HolderGetter<Biome>)this.biomeRegistry, x, z);
        return new Clime((double)Mth.clamp((int)temperature, (int)0, (int)65536) / 65536.0, (double)Mth.clamp((int)downfall, (int)0, (int)65536) / 65536.0);
    }

    @Override
    public boolean useBiomeColor() {
        return ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_BETA_FRACTAL_CLIMATIC_COLORS).vegetation();
    }

    @Override
    public boolean useSkyColor() {
        return ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_BETA_FRACTAL_CLIMATIC_COLORS).sky();
    }

    @Override
    public boolean useWaterColor() {
        return ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_BETA_FRACTAL_CLIMATIC_COLORS).water();
    }

    @Override
    public ClimateDistribution getDistribution() {
        return this.distribution;
    }

    @Override
    public double sampleSky(int x, int z) {
        return (double)this.temperatureLayer.sample((HolderGetter<Biome>)this.biomeRegistry, x, z) / 65536.0;
    }

    @Override
    public double getSnowThreshold() {
        return 0.15;
    }

    @Override
    public TemperatureHeightScaling getHeightType() {
        return TemperatureHeightScaling.NONE;
    }

    @Override
    public String getDebugText(int x, int z) {
        Clime clime = this.sample(x, z);
        double temp = clime.temp();
        double rain = clime.rain();
        return String.format("Climate Temp: %.3f Rainfall: %.3f", temp, rain);
    }
}

