/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.climate;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mod.bluestaggo.modernerbeta.world.biome.provider.climate.ClimateMapping;
import mod.bluestaggo.modernerbeta.world.biome.provider.climate.ClimateType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public class ClimateMap {
    private final Map<String, ClimateMapping> climateMap;
    private final ClimateMapping[] climateTable;

    public ClimateMap(Map<String, ClimateMapping> climateMappings) {
        this.climateMap = new LinkedHashMap<String, ClimateMapping>(climateMappings);
        this.climateTable = new ClimateMapping[4096];
        this.generateBiomeLookup();
    }

    public Map<String, ClimateMapping> getMap() {
        return new LinkedHashMap<String, ClimateMapping>(this.climateMap);
    }

    public ResourceKey<Biome> getBiome(double temp, double rain, ClimateType type) {
        int t = (int)(temp * 63.0);
        int r = (int)(rain * 63.0);
        return this.climateTable[t + r * 64].getBiome(type);
    }

    public List<ResourceKey<Biome>> getBiomeKeys() {
        ArrayList<ResourceKey<Biome>> biomeKeys = new ArrayList<ResourceKey<Biome>>();
        this.climateMap.values().forEach(mapping -> {
            biomeKeys.add(mapping.getBiome(ClimateType.LAND));
            biomeKeys.add(mapping.getBiome(ClimateType.OCEAN));
            biomeKeys.add(mapping.getBiome(ClimateType.DEEP_OCEAN));
        });
        return biomeKeys;
    }

    private void generateBiomeLookup() {
        for (int t = 0; t < 64; ++t) {
            for (int r = 0; r < 64; ++r) {
                this.climateTable[t + r * 64] = this.getBiome((float)t / 63.0f, (float)r / 63.0f);
            }
        }
    }

    private ClimateMapping getBiome(float temp, float rain) {
        rain *= temp;
        if (temp < 0.1f) {
            return this.climateMap.get("ice_desert");
        }
        if (rain < 0.2f) {
            if (temp < 0.5f) {
                return this.climateMap.get("tundra");
            }
            if (temp < 0.95f) {
                return this.climateMap.get("savanna");
            }
            return this.climateMap.get("desert");
        }
        if (rain > 0.5f && temp < 0.7f) {
            return this.climateMap.get("swampland");
        }
        if (temp < 0.5f) {
            return this.climateMap.get("taiga");
        }
        if (temp < 0.97f) {
            if (rain < 0.35f) {
                return this.climateMap.get("shrubland");
            }
            return this.climateMap.get("forest");
        }
        if (rain < 0.45f) {
            return this.climateMap.get("plains");
        }
        if (rain < 0.9f) {
            return this.climateMap.get("seasonal_forest");
        }
        return this.climateMap.get("rainforest");
    }
}

