/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.jetbrains.annotations.NotNull;

public record ExtendedBiomeId(ResourceLocation baseId, String ext, boolean weak) {
    public static final Codec<ExtendedBiomeId> CODEC = Codec.STRING.comapFlatMap(ExtendedBiomeId::validate, ExtendedBiomeId::toString);
    public static final String TRANSLATION_KEY = "createWorld.customize.modern_beta.settings.preview.extended_biome_id";
    public static final ExtendedBiomeId OCEAN = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.OCEAN);
    public static final ExtendedBiomeId DEEP_OCEAN = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.DEEP_OCEAN);
    public static final ExtendedBiomeId PLAINS = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.PLAINS);
    public static final ExtendedBiomeId RIVER = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.RIVER);
    public static final ExtendedBiomeId FROZEN_OCEAN = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.FROZEN_OCEAN);
    public static final ExtendedBiomeId SNOWY_PLAINS = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.SNOWY_PLAINS);
    public static final ExtendedBiomeId FROZEN_RIVER = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.FROZEN_RIVER);
    public static final ExtendedBiomeId BEACH = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.BEACH);
    public static final ExtendedBiomeId MUSHROOM_ISLAND = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.MUSHROOM_FIELDS);
    public static final ExtendedBiomeId MUSHROOM_SHORE = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.MUSHROOM_FIELDS, "shore");
    public static final ExtendedBiomeId CLIMATE_WARM = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.DESERT, "climate");
    public static final ExtendedBiomeId CLIMATE_TEMPERATE = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.PLAINS, "climate");
    public static final ExtendedBiomeId CLIMATE_COOL = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.TAIGA, "climate");
    public static final ExtendedBiomeId CLIMATE_SNOWY = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.SNOWY_PLAINS, "climate");
    public static final ExtendedBiomeId RIVER_REGION_A = RIVER.withExt("region_a");
    public static final ExtendedBiomeId RIVER_REGION_B = RIVER.withExt("region_b");
    public static final ExtendedBiomeId RANDOM = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.THE_VOID, "mutation");
    public static final ExtendedBiomeId WARM_OCEAN = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.WARM_OCEAN);
    public static final ExtendedBiomeId LUKEWARM_OCEAN = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.LUKEWARM_OCEAN);
    public static final ExtendedBiomeId COLD_OCEAN = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.COLD_OCEAN);
    public static final ExtendedBiomeId DEEP_LUKEWARM_OCEAN = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.DEEP_LUKEWARM_OCEAN);
    public static final ExtendedBiomeId DEEP_COLD_OCEAN = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.DEEP_COLD_OCEAN);
    public static final ExtendedBiomeId DEEP_FROZEN_OCEAN = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.DEEP_FROZEN_OCEAN);
    public static final ExtendedBiomeId NULL = ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.THE_VOID, "null");
    public static final List<ExtendedBiomeId> CLIMATE_WARM_RARE = ExtendedBiomeId.rareClimate((ResourceKey<Biome>)Biomes.BADLANDS);
    public static final List<ExtendedBiomeId> CLIMATE_TEMPERATE_RARE = ExtendedBiomeId.rareClimate((ResourceKey<Biome>)Biomes.JUNGLE);
    public static final List<ExtendedBiomeId> CLIMATE_COOL_RARE = ExtendedBiomeId.rareClimate((ResourceKey<Biome>)Biomes.OLD_GROWTH_PINE_TAIGA);
    public static final List<ExtendedBiomeId> CLIMATE_SNOWY_RARE = ExtendedBiomeId.rareClimate((ResourceKey<Biome>)Biomes.ICE_SPIKES);

    public static ExtendedBiomeId of(String id) {
        return VersionCompat.getOrThrow(ExtendedBiomeId.validate(id));
    }

    public static ExtendedBiomeId of(String baseId, String ext) {
        boolean weak = false;
        if (baseId.startsWith("~")) {
            weak = true;
            ext = "";
            baseId = baseId.substring(1);
        }
        return new ExtendedBiomeId(VersionCompat.id(baseId), ext, weak);
    }

    public static ExtendedBiomeId of(ResourceLocation baseId) {
        return new ExtendedBiomeId(baseId, "", false);
    }

    public static ExtendedBiomeId of(ResourceLocation baseId, String ext) {
        if (ext == null) {
            ext = "";
        }
        return new ExtendedBiomeId(baseId, ext, false);
    }

    public static ExtendedBiomeId ofWeak(ResourceLocation baseId) {
        return new ExtendedBiomeId(baseId, "", true);
    }

    public static ExtendedBiomeId of(ResourceKey<Biome> baseId) {
        return new ExtendedBiomeId(baseId.location(), "", false);
    }

    public static ExtendedBiomeId of(ResourceKey<Biome> baseId, String ext) {
        if (ext == null) {
            ext = "";
        }
        return new ExtendedBiomeId(baseId.location(), ext, false);
    }

    public static ExtendedBiomeId ofWeak(ResourceKey<Biome> baseId) {
        return new ExtendedBiomeId(baseId.location(), "", true);
    }

    public static List<ExtendedBiomeId> listOf(String ... ids) {
        return Arrays.stream(ids).map(ExtendedBiomeId::of).toList();
    }

    public static Set<ExtendedBiomeId> setOf(String ... ids) {
        return Arrays.stream(ids).map(ExtendedBiomeId::of).collect(Collectors.toSet());
    }

    private static List<ExtendedBiomeId> rareClimate(ResourceKey<Biome> baseId) {
        return IntStream.range(0, 15).mapToObj(i -> ExtendedBiomeId.of(baseId, "climate_" + i)).toList();
    }

    public ExtendedBiomeId withExt(String ext) {
        if (ext == null) {
            ext = "";
        }
        return new ExtendedBiomeId(this.baseId, ext, false);
    }

    public ExtendedBiomeId asWeak() {
        return new ExtendedBiomeId(this.baseId, "", true);
    }

    public ExtendedBiomeId asStrong() {
        return new ExtendedBiomeId(this.baseId, this.ext, false);
    }

    public boolean isOf(ResourceKey<Biome> biome) {
        return this.baseId.equals((Object)biome.location());
    }

    public boolean isOf(ResourceLocation biome) {
        return this.baseId.equals((Object)biome);
    }

    public Map.Entry<ExtendedBiomeId, ExtendedBiomeId> mapTo(String id) {
        ExtendedBiomeId next = !id.isEmpty() && id.charAt(0) == '*' ? this.withExt(id.substring(1)) : ExtendedBiomeId.of(id);
        return Map.entry(this, next);
    }

    @Override
    @NotNull
    public String toString() {
        Object name = this.baseId.toString();
        if (this.ext != null && !this.ext.isEmpty()) {
            name = (String)name + "*" + this.ext;
        }
        if (this.weak) {
            name = "~" + (String)name;
        }
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedBiomeId that = (ExtendedBiomeId)o;
        return Objects.equals(this.baseId, that.baseId) && (this.weak || that.weak || Objects.equals(this.ext, that.ext));
    }

    @Override
    public int hashCode() {
        return this.baseId.hashCode();
    }

    public static DataResult<ExtendedBiomeId> validate(String string) {
        int asterisk;
        String ext;
        boolean weak;
        boolean bl = weak = !string.isEmpty() && string.charAt(0) == '~';
        if (weak) {
            string = string.substring(1);
        }
        String string2 = ext = (asterisk = string.indexOf(42)) == -1 ? "" : string.substring(asterisk + 1);
        if (asterisk != -1) {
            string = string.substring(0, asterisk);
        }
        return ResourceLocation.read((String)string).flatMap(id -> DataResult.success((Object)new ExtendedBiomeId((ResourceLocation)id, ext, weak)));
    }
}

