/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import net.minecraft.util.StringRepresentable;

public record LayerTarget(Type type, String value) {
    private static final LayerTarget NONE = new LayerTarget(Type.BIOME, ExtendedBiomeId.NULL.toString());
    public static final Codec<LayerTarget> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StringRepresentable.fromEnum(Type::values).fieldOf("type").forGetter(LayerTarget::type), (App)Codec.STRING.fieldOf("value").forGetter(LayerTarget::value)).apply((Applicative)instance, LayerTarget::new));

    public static LayerTarget biome(String biome) {
        return new LayerTarget(Type.BIOME, biome);
    }

    public static LayerTarget biome(ExtendedBiomeId biome) {
        return new LayerTarget(Type.BIOME, biome.toString());
    }

    public static LayerTarget layer(String biome) {
        return new LayerTarget(Type.LAYER, biome);
    }

    public static LayerTarget none() {
        return NONE;
    }

    public Configured configure(Function<String, Layer> layerMap) {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new Configured.OfLayer(layerMap.apply(this.value));
            case 1 -> new Configured.OfBiome(ExtendedBiomeId.of(this.value));
        };
    }

    public static enum Type implements StringRepresentable
    {
        LAYER("layer"),
        BIOME("biome");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public String getSerializedName() {
            return this.id;
        }
    }

    public static interface Configured {
        public Optional<Layer> asLayer();

        public ExtendedBiomeId sample(int var1, int var2);

        public boolean isEquivalentToOrNull(Layer var1);

        public void addPossibleBiomes(Set<ExtendedBiomeId> var1);

        public record OfBiome(ExtendedBiomeId biome) implements Configured
        {
            @Override
            public Optional<Layer> asLayer() {
                return Optional.empty();
            }

            @Override
            public ExtendedBiomeId sample(int x, int z) {
                return this.biome;
            }

            @Override
            public boolean isEquivalentToOrNull(Layer layer) {
                return ExtendedBiomeId.NULL.equals(this.biome);
            }

            @Override
            public void addPossibleBiomes(Set<ExtendedBiomeId> biomes) {
                biomes.add(this.biome);
            }
        }

        public record OfLayer(Layer layer) implements Configured
        {
            @Override
            public Optional<Layer> asLayer() {
                return Optional.of(this.layer);
            }

            @Override
            public ExtendedBiomeId sample(int x, int z) {
                return this.layer.sample(x, z);
            }

            @Override
            public boolean isEquivalentToOrNull(Layer layer) {
                return this.layer == layer;
            }

            @Override
            public void addPossibleBiomes(Set<ExtendedBiomeId> biomes) {
                this.layer.addPossibleBiomesRecursive(biomes);
            }
        }
    }
}

