/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.intlayers;

import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerRandom;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;

public abstract class IntLayer {
    private final transient long seed;
    private transient long saltedSeed;
    private transient ThreadLocal<LayerRandom> random;
    private final transient ThreadLocal<Long2IntLinkedOpenHashMap> cache = ThreadLocal.withInitial(() -> {
        Long2IntLinkedOpenHashMap map = new Long2IntLinkedOpenHashMap(25);
        map.defaultReturnValue(Integer.MIN_VALUE);
        return map;
    });

    public IntLayer(long seed) {
        this.seed = seed;
        long saltedSeed = seed;
        for (int i = 0; i < 3; ++i) {
            saltedSeed = LinearCongruentialGenerator.next((long)saltedSeed, (long)seed);
        }
        this.saltedSeed = saltedSeed;
    }

    public abstract int generate(HolderGetter<Biome> var1, int var2, int var3);

    public int sample(HolderGetter<Biome> biomeRegistry, int x, int z) {
        long coord;
        Long2IntLinkedOpenHashMap cache = this.cache.get();
        int value = cache.get(coord = ChunkPos.asLong((int)x, (int)z));
        if (value != Integer.MIN_VALUE) {
            return value;
        }
        value = this.generate(biomeRegistry, x, z);
        if (cache.size() == 25) {
            cache.removeFirstInt();
        }
        cache.put(coord, value);
        return value;
    }

    public void init(long worldSeed) {
        this.saltedSeed = this.seed;
        for (int i = 0; i < 3; ++i) {
            this.saltedSeed = LinearCongruentialGenerator.next((long)this.saltedSeed, (long)this.seed);
        }
        long preWorldSeed = this.saltedSeed;
        this.saltedSeed = worldSeed;
        for (int i = 0; i < 3; ++i) {
            this.saltedSeed = LinearCongruentialGenerator.next((long)this.saltedSeed, (long)preWorldSeed);
        }
        this.random = ThreadLocal.withInitial(() -> new LayerRandom(this.saltedSeed));
    }

    protected final LayerRandom getRandom(long x, long z) {
        LayerRandom random = this.random.get();
        random.init(x, z);
        return random;
    }

    protected static Biome getBiomeFromLayer(HolderGetter<Biome> biomeRegistry, Layer layer, int x, int z) {
        ExtendedBiomeId extendedBiomeId = layer.sample(x, z);
        return biomeRegistry.get(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)extendedBiomeId.baseId())).map(Holder::value).orElse(null);
    }
}

