/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerRandom;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.PreSkipRandomLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.UnsaltedLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.LinearCongruentialGenerator;

public abstract class Layer {
    public static final int CACHE_CAPACITY = 25;
    public static final Codec<Layer> TYPE_CODEC = ModernBetaRegistries.FRACTAL_LAYER.byNameCodec().dispatch(Layer::getType, LayerType::codec);
    public final String id;
    public final long seed;
    private transient long saltedSeed;
    private transient ThreadLocal<LayerRandom> random = ThreadLocal.withInitial(() -> new LayerRandom(0L));
    private transient int initialSkip;
    private transient ThreadLocal<Long2ObjectLinkedOpenHashMap<ExtendedBiomeId>> cache = Layer.createCache();

    protected static <L extends Layer> Products.P2<RecordCodecBuilder.Mu<L>, String, Long> fillLayerFields(RecordCodecBuilder.Instance<L> instance) {
        return instance.group((App)Codec.STRING.fieldOf("id").forGetter(layer -> layer.id), (App)Codec.LONG.fieldOf("seed").orElse((Object)0L).forGetter(layer -> layer.seed));
    }

    public Layer(String id, long seed) {
        this.id = id;
        this.seed = seed;
        long saltedSeed = seed;
        for (int i = 0; i < 3; ++i) {
            saltedSeed = LinearCongruentialGenerator.next((long)saltedSeed, (long)seed);
        }
        this.saltedSeed = saltedSeed;
    }

    public abstract LayerType<?> getType();

    protected abstract ExtendedBiomeId generate(int var1, int var2);

    public void configure(Function<String, Layer> layerMap) {
    }

    protected void setInitialSkip(int initialSkip) {
        this.initialSkip = initialSkip;
    }

    protected void addPossibleBiomes(Set<ExtendedBiomeId> biomes) {
    }

    protected List<Layer> getParents() {
        return Collections.emptyList();
    }

    public void init(long worldSeed) {
        for (Layer parent : this.getParents()) {
            parent.init(worldSeed);
        }
        this.cache = Layer.createCache();
        this.saltedSeed = this.seed;
        for (int i = 0; i < 3; ++i) {
            this.saltedSeed = LinearCongruentialGenerator.next((long)this.saltedSeed, (long)this.seed);
        }
        long preWorldSeed = this.saltedSeed;
        this.saltedSeed = worldSeed;
        for (int i = 0; i < 3; ++i) {
            this.saltedSeed = LinearCongruentialGenerator.next((long)this.saltedSeed, (long)preWorldSeed);
        }
        this.random = ThreadLocal.withInitial(() -> new LayerRandom(this.saltedSeed));
    }

    public void initUnsalted() {
        for (Layer parent : this.getParents()) {
            parent.initUnsalted();
        }
        this.cache = Layer.createCache();
        this.saltedSeed = 0L;
        this.random = ThreadLocal.withInitial(() -> new LayerRandom(0L));
    }

    public ExtendedBiomeId sample(int x, int z) {
        long pos;
        Long2ObjectLinkedOpenHashMap<ExtendedBiomeId> cache = this.cache.get();
        ExtendedBiomeId biome = (ExtendedBiomeId)cache.get(pos = ColumnPos.asLong((int)x, (int)z));
        if (biome != null) {
            return biome;
        }
        biome = this.generate(x, z);
        if (cache.size() == 25) {
            cache.removeFirst();
        }
        cache.put(pos, (Object)biome);
        return biome;
    }

    protected final LayerRandom getRandom(long x, long z) {
        LayerRandom random = this.random.get();
        random.init(x, z);
        if (this.initialSkip > 0) {
            random.consumeCount(this.initialSkip);
        }
        return random;
    }

    protected final long getSaltedSeed() {
        return this.saltedSeed;
    }

    public final void addPossibleBiomesRecursive(Set<ExtendedBiomeId> biomes) {
        for (Layer parent : this.getParents()) {
            parent.addPossibleBiomesRecursive(biomes);
        }
        this.addPossibleBiomes(biomes);
    }

    public final ExtendedBiomeId[] sampleNeighbors(int x, int z) {
        return new ExtendedBiomeId[]{this.sample(x - 1, z), this.sample(x + 1, z), this.sample(x, z - 1), this.sample(x, z + 1)};
    }

    public final ExtendedBiomeId[] sampleDiagonalNeighbors(int x, int z) {
        return new ExtendedBiomeId[]{this.sample(x - 1, z - 1), this.sample(x + 1, z - 1), this.sample(x - 1, z + 1), this.sample(x + 1, z + 1)};
    }

    public final Layer skipRandom(int amount) {
        return new PreSkipRandomLayer(this.id, 0L, this, amount);
    }

    public final Layer unsalted() {
        return new UnsaltedLayer(this.id, 0L, this);
    }

    protected String getName() {
        return ModernBetaRegistries.FRACTAL_LAYER.getResourceKey(this.getType()).map(key -> {
            ResourceLocation identifier = key.location();
            if ("moderner_beta".equals(identifier.getNamespace())) {
                return identifier.getPath();
            }
            return identifier.toString();
        }).orElse("[unregistered]");
    }

    public String toString() {
        List<Layer> parents;
        String string = this.id + ": " + this.getName();
        if (this.seed != 0L) {
            string = string + " " + this.seed;
        }
        if (!(parents = this.getParents()).isEmpty()) {
            string = string + " <- " + parents.stream().map(parent -> parent.id).distinct().collect(Collectors.joining(", "));
        }
        return string;
    }

    public static boolean allNeighborsEqual(ExtendedBiomeId[] neighbors, ExtendedBiomeId i) {
        return neighbors[0].equals(i) && neighbors[1].equals(i) && neighbors[2].equals(i) && neighbors[3].equals(i);
    }

    public static boolean neighborsContain(ExtendedBiomeId[] neighbors, ExtendedBiomeId i) {
        return neighbors[0].equals(i) || neighbors[1].equals(i) || neighbors[2].equals(i) || neighbors[3].equals(i);
    }

    private static ThreadLocal<Long2ObjectLinkedOpenHashMap<ExtendedBiomeId>> createCache() {
        return ThreadLocal.withInitial(() -> new Long2ObjectLinkedOpenHashMap(25));
    }
}

