/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers;

import java.util.List;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;

public class LayerRandom
implements RandomSource {
    private final long baseSeed;
    private long seed;
    private MarsagliaPolarGaussian gaussianGenerator;

    public LayerRandom(long seed) {
        this.baseSeed = seed;
    }

    public void init(long x, long z) {
        this.seed = this.baseSeed;
        for (int i = 0; i < 2; ++i) {
            this.seed = LinearCongruentialGenerator.next((long)this.seed, (long)x);
            this.seed = LinearCongruentialGenerator.next((long)this.seed, (long)z);
        }
    }

    public RandomSource fork() {
        LayerRandom random = new LayerRandom(0L);
        random.seed = this.seed;
        return random;
    }

    public PositionalRandomFactory forkPositional() {
        return null;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public int nextInt() {
        int result = (int)(this.seed >> 24);
        this.seed = LinearCongruentialGenerator.next((long)this.seed, (long)this.baseSeed);
        return result;
    }

    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("Bound must be positive");
        }
        int result = (int)((this.seed >> 24) % (long)bound);
        if (result < 0) {
            result += bound;
        }
        this.seed = LinearCongruentialGenerator.next((long)this.seed, (long)this.baseSeed);
        return result;
    }

    public long nextLong() {
        return (long)this.nextInt() << 32 | (long)this.nextInt();
    }

    public boolean nextBoolean() {
        return this.nextInt(2) == 1;
    }

    public float nextFloat() {
        return (float)(this.nextInt() >>> 8) * 5.9604645E-8f;
    }

    public double nextDouble() {
        return (float)(this.nextInt() >>> 11) * 1.110223E-16f;
    }

    public double nextGaussian() {
        if (this.gaussianGenerator == null) {
            this.gaussianGenerator = new MarsagliaPolarGaussian((RandomSource)this);
        }
        return this.gaussianGenerator.nextGaussian();
    }

    public void consumeCount(int count) {
        for (int i = 0; i < count; ++i) {
            this.seed = LinearCongruentialGenerator.next((long)this.seed, (long)this.baseSeed);
        }
    }

    public <T> T nextItem(List<T> list) {
        return list.get(this.nextInt(list.size()));
    }
}

