/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mod.bluestaggo.modernerbeta.util.CodecUtil;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomes;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.SingleParentLayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class MixRiverLayer
extends SingleParentLayer {
    public static final MapCodec<MixRiverLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> MixRiverLayer.fillSingleParentLayerFields(instance).and(instance.group((App)Codec.STRING.fieldOf("riverSource").forGetter(layer -> layer.riverSource), (App)CodecUtil.set(ExtendedBiomeId.CODEC).fieldOf("ignoredBiomes").forGetter(layer -> layer.ignoredBiomes), (App)Codec.unboundedMap(ExtendedBiomeId.CODEC, ExtendedBiomeId.CODEC).fieldOf("biomeSpecificRivers").forGetter(layer -> layer.biomeSpecificRivers))).apply((Applicative)instance, MixRiverLayer::new));
    private final String riverSource;
    private final Set<ExtendedBiomeId> ignoredBiomes;
    private final Map<ExtendedBiomeId, ExtendedBiomeId> biomeSpecificRivers;
    private transient Layer riverSourceLayer;

    public static MixRiverLayer forEarlyRelease(String id, long seed, String parent, String riverSource) {
        return new MixRiverLayer(id, seed, parent, riverSource, Set.of(ExtendedBiomeId.OCEAN), Map.of(ExtendedBiomeId.of(ModernBetaBiomes.LATE_BETA_ICE_PLAINS), ExtendedBiomeId.FROZEN_RIVER, ExtendedBiomeId.of(ModernBetaBiomes.EARLY_RELEASE_ICE_PLAINS), ExtendedBiomeId.FROZEN_RIVER, ExtendedBiomeId.MUSHROOM_ISLAND, ExtendedBiomeId.MUSHROOM_SHORE, ExtendedBiomeId.MUSHROOM_SHORE, ExtendedBiomeId.MUSHROOM_SHORE));
    }

    public static MixRiverLayer forMajorRelease(String id, long seed, String parent, String riverSource) {
        return new MixRiverLayer(id, seed, parent, riverSource, Set.of(ExtendedBiomeId.OCEAN, ExtendedBiomeId.DEEP_OCEAN), Map.of(ExtendedBiomeId.of((ResourceKey<Biome>)Biomes.SNOWY_PLAINS), ExtendedBiomeId.FROZEN_RIVER, ExtendedBiomeId.MUSHROOM_ISLAND, ExtendedBiomeId.MUSHROOM_SHORE, ExtendedBiomeId.MUSHROOM_SHORE, ExtendedBiomeId.MUSHROOM_SHORE));
    }

    public MixRiverLayer(String id, long seed, String parent, String riverSource, Set<ExtendedBiomeId> ignoredBiomes, Map<ExtendedBiomeId, ExtendedBiomeId> biomeSpecificRivers) {
        super(id, seed, parent);
        this.riverSource = riverSource;
        this.ignoredBiomes = ignoredBiomes;
        this.biomeSpecificRivers = biomeSpecificRivers;
    }

    @Override
    public void configure(Function<String, Layer> layerMap) {
        super.configure(layerMap);
        this.riverSourceLayer = layerMap.apply(this.riverSource);
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.MIX_RIVER;
    }

    @Override
    protected List<Layer> getParents() {
        return List.of(this.parentLayer, this.riverSourceLayer);
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        ExtendedBiomeId base = this.parentLayer.sample(x, z);
        if (this.ignoredBiomes.contains(base)) {
            return base;
        }
        ExtendedBiomeId river = this.riverSourceLayer.sample(x, z);
        if (!river.equals(ExtendedBiomeId.RIVER)) {
            return base;
        }
        return this.biomeSpecificRivers.getOrDefault(base, ExtendedBiomeId.RIVER);
    }

    @Override
    protected void addPossibleBiomes(Set<ExtendedBiomeId> biomes) {
        biomes.add(ExtendedBiomeId.RIVER);
        for (Map.Entry<ExtendedBiomeId, ExtendedBiomeId> entry : this.biomeSpecificRivers.entrySet()) {
            if (!biomes.contains(entry.getKey())) continue;
            biomes.add(entry.getValue());
        }
    }
}

