/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerRandom;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.predicates.BiomePredicate;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.predicates.BiomePredicateType;

public record InGridBiomePredicate(int size, int spacing, int offset) implements BiomePredicate
{
    public static final MapCodec<InGridBiomePredicate> CODEC = VersionCompat.createMaybeMapCodec(instance -> instance.group((App)Codec.INT.fieldOf("size").forGetter(InGridBiomePredicate::size), (App)Codec.INT.fieldOf("spacing").forGetter(InGridBiomePredicate::spacing), (App)Codec.INT.fieldOf("offset").forGetter(InGridBiomePredicate::offset)).apply((Applicative)instance, InGridBiomePredicate::new));

    @Override
    public BiomePredicateType<?> getType() {
        return BiomePredicateType.IN_GRID;
    }

    @Override
    public boolean matches(ExtendedBiomeId biome, Layer layer, Supplier<LayerRandom> randomSupplier, int x, int z) {
        return Math.floorMod(x - this.offset, this.size + this.spacing) <= this.size && Math.floorMod(z - this.offset, this.size + this.spacing) <= this.size;
    }
}

