/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.cavebiome.provider;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import mod.bluestaggo.modernerbeta.api.world.cavebiome.CaveBiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.cavebiome.climate.CaveClimateSampler;
import mod.bluestaggo.modernerbeta.api.world.cavebiome.climate.CaveClime;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.CaveBiomeVoronoi;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.world.biome.voronoi.VoronoiPointCaveBiome;
import mod.bluestaggo.modernerbeta.world.biome.voronoi.VoronoiPointRules;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;

public class CaveBiomeProviderVoronoi
extends CaveBiomeProvider
implements CaveClimateSampler {
    private final VoronoiCaveClimateSampler climateSampler;
    private final VoronoiPointRules<ResourceKey<Biome>, CaveClime> rules;

    public CaveBiomeProviderVoronoi(ModernBetaSettings settings, HolderGetter<Biome> biomeRegistry, long seed) {
        super(settings, biomeRegistry, seed);
        CaveBiomeVoronoi voronoi = this.settings.getOrThrow(SettingsComponentTypes.CAVE_BIOME_VORONOI);
        this.climateSampler = new VoronoiCaveClimateSampler(seed, voronoi.verticalScale(), voronoi.horizontalScale(), voronoi.depthMinY(), voronoi.depthMaxY());
        this.rules = CaveBiomeProviderVoronoi.buildRules(voronoi.points());
    }

    @Override
    public Holder<Biome> getBiome(int biomeX, int biomeY, int biomeZ) {
        CaveClime clime = this.sample(biomeX, biomeY, biomeZ);
        ResourceKey<Biome> biomeKey = this.rules.calculateClosestTo(clime);
        return biomeKey == null ? null : this.biomeRegistry.getOrThrow(biomeKey);
    }

    @Override
    public List<Holder<Biome>> getBiomes() {
        return this.rules.getItems().stream().distinct().map(key -> this.biomeRegistry.getOrThrow(key)).collect(Collectors.toList());
    }

    @Override
    public CaveClime sample(int x, int y, int z) {
        return this.climateSampler.sample(x, y, z);
    }

    private static VoronoiPointRules<ResourceKey<Biome>, CaveClime> buildRules(List<VoronoiPointCaveBiome> points) {
        VoronoiPointRules.Builder<ResourceKey, CaveClime> builder = new VoronoiPointRules.Builder<ResourceKey, CaveClime>();
        for (VoronoiPointCaveBiome point : points) {
            ResourceKey biomeKey = point.biome().isBlank() ? null : ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)VersionCompat.id(point.biome()));
            double temp = Mth.clamp((double)point.temp(), (double)0.0, (double)1.0);
            double rain = Mth.clamp((double)point.rain(), (double)0.0, (double)1.0);
            double depth = Mth.clamp((double)point.depth(), (double)0.0, (double)1.0);
            builder.add(biomeKey, new CaveClime(temp, rain, depth));
        }
        return builder.build();
    }

    @Override
    public String getDebugText(int x, int y, int z) {
        return this.climateSampler.getDebugText(x >> 2, y >> 2, z >> 2);
    }

    private static class VoronoiCaveClimateSampler {
        private final PerlinOctaveNoise tempOctaveNoise;
        private final PerlinOctaveNoise rainOctaveNoise;
        private final PerlinOctaveNoise detailOctaveNoise;
        private final float verticalScale;
        private final float horizontalScale;
        private final int depthMinY;
        private final int depthMaxY;

        public VoronoiCaveClimateSampler(long seed, float verticalScale, float horizontalScale, int depthMinY, int depthMaxY) {
            this.tempOctaveNoise = new PerlinOctaveNoise(new Random(seed * 9871L), 2, true);
            this.rainOctaveNoise = new PerlinOctaveNoise(new Random(seed * 39811L), 2, true);
            this.detailOctaveNoise = new PerlinOctaveNoise(new Random(seed * 543321L), 1, true);
            this.verticalScale = verticalScale;
            this.horizontalScale = horizontalScale;
            this.depthMinY = depthMinY >> 2;
            this.depthMaxY = depthMaxY >> 2;
        }

        public CaveClime sample(int x, int y, int z) {
            double tempNoise = this.tempOctaveNoise.sample((double)x / (double)this.horizontalScale, (double)y / (double)this.verticalScale, (double)z / (double)this.horizontalScale);
            double rainNoise = this.rainOctaveNoise.sample((double)x / (double)this.horizontalScale, (double)y / (double)this.verticalScale, (double)z / (double)this.horizontalScale);
            double detailNoise = this.detailOctaveNoise.sample((double)x / (double)this.horizontalScale, (double)y / (double)this.verticalScale, (double)z / (double)this.horizontalScale);
            tempNoise /= 1.4;
            rainNoise /= 1.4;
            tempNoise = tempNoise * 0.99 + (detailNoise /= 0.55) * 0.01;
            rainNoise = rainNoise * 0.98 + detailNoise * 0.02;
            tempNoise = (tempNoise + 1.0) / 2.0;
            rainNoise = (rainNoise + 1.0) / 2.0;
            int depthHeight = this.depthMaxY - this.depthMinY;
            double depth = Mth.clamp((int)y, (int)this.depthMinY, (int)this.depthMaxY);
            depth -= (double)this.depthMinY;
            return new CaveClime(Mth.clamp((double)tempNoise, (double)0.0, (double)1.0), Mth.clamp((double)rainNoise, (double)0.0, (double)1.0), Mth.clamp((double)(depth /= (double)depthHeight), (double)0.0, (double)1.0));
        }

        private String getDebugText(int x, int y, int z) {
            CaveClime clime = this.sample(x, y, z);
            double temp = clime.temp();
            double rain = clime.rain();
            return String.format("Cave Climate Temp: %.3f Rainfall: %.3f", temp, rain);
        }
    }
}

